<?php
/**
 * Plugin Name: Pistacia Demo Importer
 * Plugin URI: http://wp.pistaciatheme.com/pistacia
 * Description: You can import demo data with one click
 * Version: 1.6.7
 * Author: Pistaciatheme
 * Author URI: http://themeforest.net/user/pistaciatheme
 * License: GPL-3.0
 * Plugin textdomain: pistacia_demo_importer
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define('PISTACIA_DEMO_IMPORTER_PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('PISTACIA_DEMO_IMPORTER_PLUGIN_URI', plugin_dir_url( __FILE__ ));

/**
 * Class autoloader
 */
function pistacia_demo_importer_autoloader( $className )  {
    $file = plugin_dir_path( __FILE__ ) . '/class/' . strtolower($className) . '.php';
    if( file_exists( $file ) ) {
        require_once( $file );
    }
}

spl_autoload_register('pistacia_demo_importer_autoloader');

new pistacia_demo_importer_admin();