<?php /**
 * pistacia_demo_importer_admin.php
 *
 * This file contains demo importer admin
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia_demo_importer
 * @since          pistacia_demo_importer 1.5.4
 */

if(!class_exists('pistacia_demo_importer_admin')) {
    class pistacia_demo_importer_admin
    {
        function __construct(){
            add_action('admin_menu', array($this,'importer_submenu_setup'));
            add_action('wp_ajax_pistacia_import_demo', array($this,'pistacia_import_demo'));
            add_action('wp_ajax_nopriv_pistacia_import_demo', array($this,'pistacia_import_demo')) ;

            add_action('plugins_loaded', array(&$this, 'load_textdomain'));

        }
        function  importer_submenu_setup(){
            add_theme_page( esc_html__('Install Demos','pistacia_demo_importer'), esc_html__('Install Demos','pistacia_demo_importer'), 'manage_options', 'demo-importer', array( &$this,'pistacia_demos_admin') );
        }

        function pistacia_demos_admin()
        {
            include_once(PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . '/class/importer-admin.php');
        }

        function pistacia_import_demo() {

                $content_importer = new pistacia_demo_importer();
                $content_importer->import();

        }

        public function load_textdomain()
        {
            load_theme_textdomain('pistacia_demo_importer', PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . '/lang');
        }

    }

}