<?php /**
 * pistacia_demo_importer.php
 *
 * This file contains demo importer
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia_demo_importer
 * @since          pistacia_demo_importer 1.5.4
 */

if(!class_exists('pistacia_demo_importer')){
    class pistacia_demo_importer
    {
        private $template = null;
        private $theme_content_path = "";
        private $widget_content_path = "";

        function __construct()
        {

            $this->template                  = true;
            $this->is_options                = true;
            $this->is_content                = true;
            $this->is_widgets                = true;
            $this->is_slider                 = true;
            $this->theme_content_path        = PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . '/demos/main/sample-data.xml';
            $this->theme_options_path        = PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . '/demos/main/options.json';
            $this->widget_content_path       = PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . '/demos/main/widget-data.wie';

            if ( !defined('WP_LOAD_IMPORTERS') ) define('WP_LOAD_IMPORTERS', true);
            require_once ABSPATH . 'wp-admin/includes/import.php';

            if (!class_exists('WP_Importer')) {
                $class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
                if ( file_exists( $class_wp_importer ) ){
                    require_once($class_wp_importer);
                }
            }

            if (!class_exists('WP_Import')) {
                $wp_import = 'wordpress-importer.php';
                include $wp_import;
            }

        }


        private function import_menus_locations()
        {
            if ($this->is_content == 'true') {

                $locations = get_theme_mod('nav_menu_locations');
                $menus  = wp_get_nav_menus();

                if ($menus) {

                    foreach ($menus as $locationId => $menuValue) {

                        if (
                            $menuValue->name == 'Main Navigation' ||
                            $menuValue->name == 'Main' ||
                            $menuValue->slug == 'Main Menu'||
                            $menuValue->name == 'Main Nav') {

                            $locations['primary-menu'] = $menuValue->term_id;
                            echo '<li>'.esc_html__('Main Navigation location is configured.','pistacia_demo_importer').'</li>';

                        }

                        switch($menuValue->name) {
                            case 'Top Menu':
                                $locations['top-menu'] = $menuValue->term_id;
                                break;

                            case 'Footer Menu':
                                $locations['footer-menu'] = $menuValue->term_id;
                                break;
                        }

                    }

                }

                set_theme_mod('nav_menu_locations', $locations);

            }
        }
        private function set_up_pages()
        {
            if ($this->is_content == 'true') {

                $homepage = get_page_by_title('Home page 1');

                if (empty($homepage->ID)) {
                    $homepage = get_page_by_title('Home page 2');
                    if (empty($homepage->ID)) {
                        $homepage = get_page_by_title('Home page 3');
                    }
                }

                if (!empty($homepage->ID)) {
                    update_option('page_on_front', $homepage->ID);
                    update_option('show_on_front', 'page');
                    echo '<li>'. esc_html__('Default homepage is configured.','pistacia_demo_importer').'</li>';
                }

                $shop_page = get_page_by_title('Shop');

                if(!empty($shop_page->ID)) {
                    update_option('woocommerce_shop_page_id', $shop_page->ID);
                    echo '<li>'. esc_html__("Shop Page is configured.","pistacia_demo_importer").'</li>';
                }

            }

        }

        private function import_theme_content()
        {
            if ($this->is_content == 'true') {
                set_time_limit(0);
                $importer = new WP_Import();
                $importer->fetch_attachments = false;
                ob_start();
                $importer->import($this->theme_content_path);
                ob_end_clean();
                echo '<li>' . esc_html__('Template contents were imported.','pistacia_demo_importer') . '</li>';
                return true;
            }
        }

        private function pistacia_rev_slider_import(){

            if ( class_exists( 'RevSlider') && $this->is_slider == 'true' ) {

                $sliders = array();

                $files = glob( PISTACIA_DEMO_IMPORTER_PLUGIN_DIR .'sliders/*.zip');
                foreach($files  as $name){
                    $explode_file = (explode('/',$name));
                    $file = end($explode_file);
                    $explode_ext = (explode('.',$file));
                    $filename = ($explode_ext[0]);
                    $sliders[$filename] = PISTACIA_DEMO_IMPORTER_PLUGIN_DIR . 'sliders/'. $file;
                }

                if ( !empty( $sliders ) ) {

                    foreach($sliders as $slider){
                        if ( file_exists( $slider ) ) {
                            $s = new RevSlider();
                            $s->importSliderFromPost( true, true, $slider );
                            echo '<li>'. esc_html__("Rev slider imported.","pistacia_demo_importer").'</li>';
                        }
                    }
                    return true;
                }

            }
        }

        /**
         * Available widgets
         *
         * Gather site's widgets into array with ID base, name, etc.
         * Used by export and import functions.
         *
         * @since 2.2.0
         *
         * @global array $wp_registered_widget_updates
         * @return array Widget information
         */
        function pistacia_available_widgets()
        {

            if ($this->is_widgets === true ) {
                global $wp_registered_widget_controls;
                $widget_controls   = $wp_registered_widget_controls;
                $available_widgets = array();
                foreach ($widget_controls as $widget) {
                    if (!empty($widget['id_base']) && !isset($available_widgets[$widget['id_base']])) {
                        $available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
                        $available_widgets[$widget['id_base']]['name']    = $widget['name'];
                    }
                }
                return apply_filters('pistacia_available_widgets', $available_widgets);
            }

        }

        /**
         * Process import file
         *
         * This parses a file and triggers importation of its widgets.
         *
         * @since 2.2.0
         *
         * @param string $file Path to .wie file uploaded
         * @global string $widget_import_results
         */
        private function pistacia_process_widget_import()
        {
            if ($this->is_widgets === true) {
                global $pistacia_import_results;
                $pistacia_import_results = $this->pistacia_import_widgets(json_decode(file_get_contents($this->widget_content_path)));
            }
        }

        /**
         * Import widget JSON data
         *
         * @since 2.2.0
         * @global array $wp_registered_sidebars
         * @param object $data JSON widget data from .wie file
         * @return array Results array
         */

        private function pistacia_import_widgets($data)
        {
            global $wp_registered_sidebars;

            $available_widgets = $this->pistacia_available_widgets();
            $widget_instances  = array();
            foreach ($available_widgets as $widget_data) {
                $widget_instances[$widget_data['id_base']] = get_option('widget_' . $widget_data['id_base']);
            }
            if (empty($data) || !is_object($data)) {
                wp_die(esc_html__('Import data could not be read. Please try a different file.', 'pistacia_demo_importer'), '', array(
                    'back_link' => true
                ));
            }
            $results = array();
            foreach ($data as $sidebar_id => $widgets) {
                if ('wp_inactive_widgets' == $sidebar_id) {
                    continue;
                }
                if (isset($wp_registered_sidebars[$sidebar_id])) {
                    $sidebar_available    = true;
                    $use_sidebar_id       = $sidebar_id;
                    $sidebar_message_type = 'success';
                    $sidebar_message      = '';
                } else {
                    $sidebar_available    = false;
                    $use_sidebar_id       = 'wp_inactive_widgets';
                    $sidebar_message_type = 'error';
                    $sidebar_message      = esc_html__('Sidebar does not exist in theme (using Inactive)', 'pistacia_demo_importer');
                }
                $results[$sidebar_id]['name']         = !empty($wp_registered_sidebars[$sidebar_id]['name']) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id;
                $results[$sidebar_id]['message_type'] = $sidebar_message_type;
                $results[$sidebar_id]['message']      = $sidebar_message;
                $results[$sidebar_id]['widgets']      = array();
                foreach ($widgets as $widget_instance_id => $widget) {
                    $fail               = false;
                    $id_base            = preg_replace('/-[0-9]+$/', '', $widget_instance_id);
                    $instance_id_number = str_replace($id_base . '-', '', $widget_instance_id);
                    if (!$fail && !isset($available_widgets[$id_base])) {
                        $fail                = true;
                        $widget_message_type = 'error';
                        $widget_message      = esc_html__('Site does not support widget', 'pistacia_demo_importer');
                    }
                    $widget = apply_filters('pistacia_widget_settings', $widget);
                    if (!$fail && isset($widget_instances[$id_base])) {
                        $sidebars_widgets        = get_option('sidebars_widgets');
                        $sidebar_widgets         = isset($sidebars_widgets[$use_sidebar_id]) ? $sidebars_widgets[$use_sidebar_id] : array();
                        $single_widget_instances = !empty($widget_instances[$id_base]) ? $widget_instances[$id_base] : array();
                        foreach ($single_widget_instances as $check_id => $check_widget) {
                            if (in_array("$id_base-$check_id", $sidebar_widgets) && (array) $widget == $check_widget) {
                                $fail                = true;
                                $widget_message_type = 'warning';
                                $widget_message      = esc_html__('Widget already exists', 'pistacia_demo_importer');
                                break;
                            }
                        }
                    }
                    if (!$fail) {
                        $single_widget_instances   = get_option('widget_' . $id_base);
                        $single_widget_instances   = !empty($single_widget_instances) ? $single_widget_instances : array(
                            '_multiwidget' => 1
                        );
                        $single_widget_instances[] = (array) $widget;
                        end($single_widget_instances);
                        $new_instance_id_number = key($single_widget_instances);
                        if ('0' === strval($new_instance_id_number)) {
                            $new_instance_id_number                           = 1;
                            $single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
                            unset($single_widget_instances[0]);
                        }
                        if (isset($single_widget_instances['_multiwidget'])) {
                            $multiwidget = $single_widget_instances['_multiwidget'];
                            unset($single_widget_instances['_multiwidget']);
                            $single_widget_instances['_multiwidget'] = $multiwidget;
                        }
                        update_option('widget_' . $id_base, $single_widget_instances);
                        $sidebars_widgets                    = get_option('sidebars_widgets');
                        $new_instance_id                     = $id_base . '-' . $new_instance_id_number;
                        $sidebars_widgets[$use_sidebar_id][] = $new_instance_id;
                        update_option('sidebars_widgets', $sidebars_widgets);
                        if ($sidebar_available) {
                            $widget_message_type = 'success';
                            $widget_message      = esc_html__('Imported', 'pistacia_demo_importer');
                        } else {
                            $widget_message_type = 'warning';
                            $widget_message      = esc_html__('Imported to Inactive', 'pistacia_demo_importer');
                        }
                    }
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['name']         = isset($available_widgets[$id_base]['name']) ? $available_widgets[$id_base]['name'] : $id_base;
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['title']        = $widget->title ? $widget->title : esc_html__('No Title', 'pistacia_demo_importer');
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
                    $results[$sidebar_id]['widgets'][$widget_instance_id]['message']      = $widget_message;

                }

            }
            echo '<li>Widgets are imported.</li>';
        }



        public function import()
        {

            if (class_exists('WP_Importer') && class_exists('WP_Import')) {

                $imported_message = '<ul>';
                if ($this->import_theme_content()) {
                    $this->import_menus_locations();
                    $this->set_up_pages();
                }

                $this->pistacia_rev_slider_import();
                $this->pistacia_process_widget_import();

                $imported_message .= '</ul>';
                echo $imported_message;

                die();
            }
        }
    }
}