<?php

wp_enqueue_style('pistacia-importer-styles', PISTACIA_DEMO_IMPORTER_PLUGIN_URI . '/css/style.css', false, false, 'all');

function pistacia_nt_size_check($size)
{
    $let = substr($size, -1);
    $ret = substr($size, 0, -1);
    switch (strtoupper($let)) {
        case 'P':
            $ret *= 1024;
        case 'T':
            $ret *= 1024;
        case 'G':
            $ret *= 1024;
        case 'M':
            $ret *= 1024;
        case 'K':
            $ret *= 1024;
    }
    return $ret;
}

$pistacia_max_execution_time  = ini_get("max_execution_time");
$pistacia_max_input_time      = ini_get("max_input_time");
$pistacia_upload_max_filesize = ini_get("upload_max_filesize");

if ( $pistacia_max_execution_time < 100 ||
    $pistacia_max_input_time < 100 ||
    pistacia_nt_size_check(WP_MEMORY_LIMIT) < 100663296 ||
    pistacia_nt_size_check($pistacia_upload_max_filesize) < 10485760 ) : ?>

    <div class="import-wrap">
        <table class="wc_status_table widefat" cellspacing="0">
            <thead>
                <tr>
                    <th colspan="2"><?php esc_html_e('Environment','pistacia_demo_importer');?></th>
                </tr>
            </thead>
            <tbody>
                <?php if($pistacia_max_execution_time < 100): ?>
                    <tr>
                        <td><?php esc_html_e("Maximum Execution Time","pistacia_plugin"); ?></td>
                        <td><?php echo $pistacia_max_execution_time; ?><br><span style="color: red"><?php esc_html_e("Recommended max_execution_time should be at least 100 Seconds","pistacia_plugin"); ?></span></td>
                    </tr>
                <?php endif; ?>

                <?php if($pistacia_max_input_time < 100): ?>
                    <tr>
                        <td><?php esc_html_e('Maximum Input Time','pistacia_demo_importer');?></td>
                        <td><?php echo $pistacia_max_input_time; ?><br><span style="color: red"><?php esc_html_e("Recommended max_input_time should be at least 100 Seconds.","pistacia_plugin"); ?></span></td>
                    </tr>
                <?php endif; ?>

                <?php if(pistacia_nt_size_check(WP_MEMORY_LIMIT) < 100663296): ?>
                    <tr>
                        <td><?php esc_html_e('WordPress Memory Limit','pistacia_demo_importer');?></td>
                        <td><?php echo WP_MEMORY_LIMIT; ?><br><span style="color: red"><?php esc_html_e("Recommended memory limit should be at least 96MB. ","pistacia_plugin"); ?><a target="_blank" href="http://codex.wordpress.org/Editing_wp-config.php#Increasing_memory_allocated_to_PHP"><?php esc_html_e('Learn More','pistacia_demo_importer');?></a></span></td>
                    </tr>
                <?php endif; ?>

                <?php if(pistacia_nt_size_check($pistacia_upload_max_filesize) < 10485760): ?>
                    <tr>
                        <td><?php esc_html_e('Maximum Upload File Size','pistacia_demo_importer');?></td>
                        <td><?php echo $pistacia_upload_max_filesize; ?><br><span style="color: red"><?php esc_html_e("Recommended Maximum Upload Filesize should be at least 10MB.","pistacia_plugin"); ?></span></td>
                    </tr>
                <?php endif; ?>
            </tbody>

        </table>
    </div>
<?php endif; ?>

<div class="ui-dialog ui-widget ui-widget-content ui-corner-all ui-front tpdialogs ui-dialog-buttons ui-draggable" tabindex="-1" role="dialog" aria-describedby="dialog_import_slider" aria-labelledby="ui-id-1" style="height: auto; width: 600px; top: 302.5px; left: 651.5px; display: none;"><div class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix"><span id="ui-id-1" class="ui-dialog-title">Import Slider</span><button class="ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only ui-dialog-titlebar-close" role="button" aria-disabled="false" title="close"><span class="ui-button-icon-primary ui-icon ui-icon-closethick"></span><span class="ui-button-text">close</span></button></div><div id="dialog_import_slider" class="dialog_import_slider ui-dialog-content ui-widget-content" style="width: auto; min-height: 0px; max-height: none; height: 254px;">
        <form action="http://localhost/wp-2/wp-admin/admin-ajax.php" enctype="multipart/form-data" method="post">
            <input type="hidden" name="action" value="revslider_ajax_action">
            <input type="hidden" name="client_action" value="import_slider_slidersview">
            <input type="hidden" name="nonce" value="666a7df512">
            <?php esc_html_e("Choose the import file:","pistacia_plugin"); ?>
            <br>
            <input type="file" size="60" name="import_file" class="input_import_slider">
            <br><br>
            <span style="font-weight: 700;"><?php esc_html_e("Note: custom styles will be updated if they exist!","pistacia_plugin"); ?></span><br><br>
            <table>
                <tbody><tr>
                        <td><?php esc_html_e("Custom Animations:","pistacia_plugin"); ?></td>
                        <td><input type="radio" name="update_animations" value="true" checked="checked"> <?php esc_html_e("overwrite","pistacia_plugin"); ?></td>
                        <td><input type="radio" name="update_animations" value="false"> <?php esc_html_e("append","pistacia_plugin"); ?></td>
                    </tr>
                    <tr>
                        <td>Static Styles:</td>
                        <td><input type="radio" name="update_static_captions" value="true" checked="checked"> <?php esc_html_e("overwrite","pistacia_plugin"); ?></td>
                        <td><input type="radio" name="update_static_captions" value="false"> <?php esc_html_e("append","pistacia_plugin"); ?></td>
                    </tr>
                </tbody></table>
            <br><br>
            <input type="submit" class="button-primary" value="Import Slider" original-title="">
        </form>
    </div>
    <div class="ui-dialog-buttonpane ui-widget-content ui-helper-clearfix">
        <div class="ui-dialog-buttonset">
            <button type="button" class="ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only" role="button" aria-disabled="false"><span class="ui-button-text"><?php esc_html_e("Close","pistacia_plugin"); ?></span></button>
        </div>
    </div>
</div>


<div class="demo-import-message"></div>

<div class="demo-importing-message import-wrap"><img src="<?php echo PISTACIA_DEMO_IMPORTER_PLUGIN_URI; ?>/img/spinner.gif"> &nbsp; <?php esc_html_e('The demo is being imported, please wait until it is finished.','pistacia_demo_importer'); ?></div>

<div id="importer-wrapper">

    <div class="demo-import-dialog"></div>

    <h1><?php esc_html_e('Install Demos', 'pistacia_demo_importer'); ?> </h1>

    <div class="import-package"><div>
            <form method="post">
                <input class="template-name" type="hidden" name="template" value="main">
                <img src="<?php echo PISTACIA_DEMO_IMPORTER_PLUGIN_URI; ?>/demos/main/preview.jpg" alt="thumb">
                <h2 class="demo-importer-title"><?php esc_html_e('Main','pistacia_demo_importer'); ?> </h2>

                <div class="button-holder">
                    <input  type="button" value="<?php esc_html_e('Install', 'pistacia_demo_importer'); ?>" class="button-primary pistacia-import-btn" />
                    <a href="http://wp.pistaciatheme.com/pistacia" target="_blank" class="button"><?php esc_html_e('Preview', 'pistacia_demo_importer'); ?></a>
                </div>
            </form>
        </div>

    </div>

    <script type="text/javascript">

        jQuery(document).ready(function() {

            "use strict";

            jQuery('.pistacia-import-btn').click(function(e){

                var import_true = confirm( '<?php esc_html_e('Are you sure to import dummy content?','pistacia_demo_importer');?>');

                if(import_true == false) return;

                jQuery('.demo-importing-message').show();

                jQuery('.import_message').html('<div class="updated settings-error"><div class="import-content-loading"><?php esc_html_e("Please be patient while template is being imported. This process may take a couple of minutes.","pistacia_plugin"); ?></div></div>');

                jQuery.ajax({
                    type: "post",
                    url: ajaxurl,
                    data: {
                        action: 'pistacia_import_demo'
                    },
                    success: function(response) {
                        jQuery('.demo-import-message').html('<div class="updated settings-error">'+ response +'</div>');
                        jQuery('.demo-import-message div').show();
                        jQuery('.demo-importing-message').hide();
                    }
                });

                e.preventDefault();
            });
        });

    </script>

