<?php
/**
 * Related Products
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

if ( empty( $product ) || ! $product->exists() ) {
    return;
}

$related = $product->get_related( 6 );

if ( sizeof( $related ) == 0 ) return;

$args = apply_filters( 'woocommerce_related_products_args', array(
    'post_type'            => 'product',
    'ignore_sticky_posts'  => 1,
    'no_found_rows'        => 1,
    'posts_per_page'       => 6,
    'orderby'              => $orderby,
    'post__in'             => $related,
    'post__not_in'         => array( $product->id )
) );

$products = new WP_Query( $args );

$woocommerce_loop['columns'] = $columns;

if ( $products->have_posts() ) : ?>

    <div class="related products">

        <h3><?php esc_html_e('You may also be interested in the following products','pistacia');?></h3>


        <div class="swiper-container interested-in-carousel">

            <div class="swiper-wrapper">

                <?php while ( $products->have_posts() ) : $products->the_post(); ?>

                    <div class="swiper-slide item">

                        <div class="item-inner">

                            <?php $img_id = get_post_thumbnail_id( get_the_ID() ); ?>
                            <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'medium' ); ?>
                            <?php if ( has_post_thumbnail( get_the_ID() )):?>
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail('large',array(
                                        'alt' => get_post_meta( $img_id, '_wp_attachment_image_alt', true)
                                    ));?>
                                </a>
                            <?php endif; ?>
                            <h4><?php the_title(); ?></h4>
                            <?php woocommerce_template_single_rating(); ?>
                            <?php woocommerce_template_single_price(); ?>
                            <a class="button" href="<?php the_permalink(); ?>"><?php esc_html_e('More','pistacia');?></a>

                        </div>

                    </div>

                <?php endwhile; ?>

            </div>

            <div class="interested-swiper-pagination"></div>

        </div>

    </div>

<?php endif;

wp_reset_postdata();
