<?php
/**
 * The Template for displaying all single products.
 *
 * Override this template by copying it to yourtheme/woocommerce/single-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

get_header( 'shop' ); ?>

<?php while ( have_posts() ) : the_post(); ?>

    <?php global $product; ?>

    <section class="shop-item" id="shopItem">

        <div class="inner">

            <div class="container">

                <div class="row">

                    <?php $featured_img_id = get_post_thumbnail_id( get_the_ID() ); ?>
                    <?php $featured_img_url_full = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>
                    <?php $featured_img_url_thumb = wp_get_attachment_thumb_url( get_post_thumbnail_id( get_the_ID() ) ); ?>

                    <?php $attachment_ids = $product->get_gallery_attachment_ids();?>

                    <?php $is_photo = ( ( !empty( $featured_img_url_full ) ) || ( !empty( $attachment_ids ) ) ) ? true : false; ?>

                    <?php if ( $is_photo ) : ?>

                        <div class="col-md-6">

                            <div class="photos">
                                <div class="photo-wrapper">
                                    <div class="carousel-wrapper">
                                        <div class="flexslider shop-item-carousel" id="shop-item-carousel">

                                            <ul class="slides">
                                                <?php if( !empty( $featured_img_url_full ) ) : ?>
                                                    <li>
                                                        <div class="photo-item zoom">
                                                            <img alt="" src="<?php echo esc_url( $featured_img_url_full[0] );?>">
                                                        </div>
                                                    </li>
                                                <?php endif; ?>

                                                <?php if( !empty( $attachment_ids ) ) : ?>
                                                    <?php foreach( $attachment_ids as $attachment_id ) :?>
                                                        <?php $img_big_src = wp_get_attachment_image_src( $attachment_id, 'full', false ); ?>
                                                        <li>
                                                            <div class="photo-item zoom">
                                                                <img alt="" src="<?php echo esc_url( $img_big_src[0] );?>">
                                                            </div>
                                                        </li>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <?php if( !empty( $attachment_ids ) ): ?>
                                    <div class="flexslider shop-item-carousel-nav" id="shop-item-carousel-nav">
                                        <ul class="slides">
                                            <?php if ( !empty($featured_img_url_thumb)) : ?>
                                                <li>
                                                    <div class="photo-item">
                                                        <img alt="" src="<?php echo esc_url( $featured_img_url_thumb ); ?>">
                                                    </div>
                                                </li>
                                            <?php endif; ?>
                                            <?php foreach( $attachment_ids as $attachment_id ) :?>
                                                <li>
                                                    <div class="photo-item">
                                                        <img alt="" src="<?php echo esc_url( wp_get_attachment_thumb_url( $attachment_id ) );?>">
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>

                            </div>

                        </div>

                    <?php endif; ?>

                    <div class="col-md-<?php echo ( $is_photo ) ? 6 : 12; ?> ">
                        <h1 class="shop-item-title"><span class="light"><?php the_title(); ?></span></h1>
                        <?php woocommerce_template_single_rating(); ?>
                        <div class="lead"><?php woocommerce_template_single_excerpt(); ?></div>
                        <?php woocommerce_template_single_meta();?>
                        <hr>
                        <div class="clearfix price-wrapper">
                            <?php woocommerce_template_single_price(); ?>
                            <?php woocommerce_template_single_add_to_cart(); ?>
                        </div>
                        <hr>

                        <?php pistacia_the_share_buttons( get_permalink() );?>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <div class="woo-tabs">
        <div class="container">
            <?php woocommerce_output_product_data_tabs();?>
        </div>
    </div>

    <section class="interested-items">
        <div class="container">
            <?php woocommerce_output_related_products();?>
        </div>
    </section>

<?php endwhile;?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer( 'shop' ); ?>