<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

get_header( 'shop' ); ?>

<header class="header">
    <div class="header-img woo-header-img" style="background-image:url('<?php header_image(); ?>')">
        <div class="overlay overlay-black-70"></div>
        <div class="container">
            <div class="row">
                <div class="col-md-8 col-md-push-2">
                    <div class="woo-header-search">
                        <?php get_product_search_form(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>

<?php $aside = ( is_active_sidebar( 'pistacia_products_sb' ) ) ? true : false; ?>
<?php $aside_alignment = ( function_exists('get_field') && get_field('pistacia_o_shpprdcts_aside','option') ) ? get_field('pistacia_o_shpprdcts_aside','option') : 'left'; ?>

<?php if ( have_posts() ) : ?>

    <section class="shop shop-thumb" id="shop">

        <div class="container">

            <?php do_action( 'woocommerce_before_main_content' ); ?>

            <div class="row">

                <div class="col-md-9 products-items-list<?php echo ( $aside_alignment == 'left' ) ? ' col-md-push-3' : ''; ?>">

                    <div class="row">

                        <div class="col-md-12">

                            <div class="list-toolbar">

                                <div class="filters clearfix">

                                    <div class="page-limiter">
                                        <?php woocommerce_result_count(); ?>
                                        <?php woocommerce_catalog_ordering();?>
                                    </div>

                                    <p class="view-mode">
                                        <label class="hidden-xs"><?php esc_html_e('View as','pistacia'); ?>:</label>
                                        <a href="#" class="active" data-mode="shop-thumb"><i class="fa fa-th"></i></a>
                                        <a href="#" data-mode="shop-list"><i class="fa fa-th-list"></i></a>
                                    </p>
                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="row">

                        <?php do_action( 'woocommerce_before_shop_loop' ); ?>

                        <?php woocommerce_product_loop_start(); ?>

                        <?php while ( have_posts() ) : the_post(); ?>

                            <?php global $product; ?>

                            <li class="item col-md-4 col-sm-6 item product hvr-float-shadow">

                                <div class="container-inner clearfix">

                                    <?php $img_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'medium' ); ?>

                                    <div class="photo" style="background-image:url('<?php echo esc_url( $img_url[0] ); ?>');">
                                        <?php woocommerce_template_single_price(); ?>
                                    </div>

                                    <?php if ( $product->is_featured() ) : ?>
                                        <span class="ribbon ribbon-primary"><i class="fa fa-star"></i></span>
                                    <?php endif; ?>

                                    <div class="text-center product-detail">
                                        <div class="star-wrapper">
                                            <?php woocommerce_template_single_rating(); ?>
                                        </div>
                                        <h2 class="product-name"><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h2>
                                        <p class="min-excerpt"><?php echo substr( esc_html( get_the_excerpt() ), 0 , 60 ); ?>...</p>
                                        <p class="full-excerpt"><?php echo esc_html( get_the_excerpt()); ?></p>
                                        <div class="button-wrapper"><a href="<?php the_permalink(); ?>" class="more-button"><?php esc_html_e('More','pistacia'); ?></a></div>
                                        <?php woocommerce_template_loop_add_to_cart(); ?>

                                    </div>

                                    <div class="product-detail-more hide">

                                        <h4><?php esc_html_e('Product detail','pistacia'); ?></h4>

                                        <p><?php echo esc_html( get_the_excerpt() ); ?></p>

                                        <ul class="tags">
                                            <li><a href="#">Estnon</a></li>
                                            <li><a href="#">Etiam faucibus leo</a></li>
                                            <li><a href="#">facilisis magna</a></li>
                                        </ul>

                                    </div>

                                </div>

                            </li>

                        <?php endwhile; ?>

                        <?php woocommerce_product_loop_end(); ?>

                        <?php do_action( 'woocommerce_after_shop_loop' ); ?>

                    </div>

                </div>


                <?php if ( $aside ) : ?>
                    <div class="col-md-3 pistacia-aside<?php echo ( $aside_alignment == 'left' ) ? ' col-md-pull-9' : ''; ?>">
                        <?php dynamic_sidebar( 'pistacia_products_sb' ); ?>
                    </div>
                <?php endif; ?>

            </div>

            <?php do_action( 'woocommerce_after_main_content' ); ?>

        </div>

    </section>


<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

    <?php wc_get_template( 'loop/no-products-found.php' ); ?>

<?php endif; ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer( 'shop' ); ?>
