<?php /**
 * ps_vc_section_welcome_header_template.php
 *
 * Visual Composer Pistacia Section Welcome Header template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

$attributes = ( shortcode_atts( array(
    'autoplay' => 500,
    'more_button_text' => esc_html__('More','pistacia')
), $atts ) ); ?>
<?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
<?php $items = $pistacia_helpers->get_shortcodes_array('ps_vc_welcome_header_item',$content);?>
<?php if (!empty($items)): ?>

<header class="header welcome-header-wrapper">
  <div class="welcome-header" id="welcomeHeader"> 
    <!-- <div class="overlay overlay-black-40"></div> -->
    <div class="welcome-img-slider">
      <ul class="slides clearfix">
        <?php foreach($items as $item) : ?>
        <?php $big_src = ( $item['big_img'] !='' ) ? wp_get_attachment_image_src( (int)$item['big_img'], 'full') : null; ?>
        <li style="background-image:url('<?php echo esc_url($big_src[0]); ?>');"></li>
        <?php endforeach; ?>
      </ul>
    </div>
    <div class="welcome-inner">
      <div class="container">
        <div class="text-slider welcome-flexslider  welcome-text">
            <ul class="slides">
                <li class="text-center banner-text">
                    ”Mitt fokus & arbetsförmåga påverkades negativt av maten jag åt i skolåldern & in i vuxenlivet.
                    Därför vill jag coacha dagens barn, ungdomar och vuxna och ge dem bättre förutsättningar genom ökad
                    kunskap om mat både teoretiskt och praktiskt. Det bygger långsiktigt välmående och förbättrade
                    resultat”. <span>Cecilia Walton, ägare Kreativa Kök</span>
                </li>
            </ul>

        </div>

        <div role="tabpanel" class="quickcategories clearfix">
          <ul class="nav nav-tabs" role="tablist">
            <li role="presentation"> <a href="<?php echo site_url();?>/kontakta-oss/"> <i class="fa fa-mouse-pointer"></i> <span class="hidden-xs">Boka kurs</span> </a> </li>
            <li role="presentation"> <a href="<?php echo site_url();?>/kontakta-oss/"> <i class="fa fa-comment-o"></i> <span class="hidden-xs">Fråga oss</span> </a> </li>
            <li role="presentation"> <a href="<?php echo site_url();?>/produkt-kategori/presentkort/"> <i class="fa fa-gift"></i> <span class="hidden-xs">Presentkort</span> </a> </li>
            <li role="presentation"> <a href="<?php echo site_url();?>/butik-koksredskap/"> <i class="fa fa-shopping-cart"></i> <span class="hidden-xs">Produktbutik</span> </a> </li>
            <li role="presentation"> <a href="<?php echo site_url();?>/start/om-kreativa-kok-halsa/"> <i class="fa fa-user"></i> <span class="hidden-xs">Om oss</span> </a> </li>

          </ul>
        <!--  <div class="tab-content ">
            <div role="tabpanel" class="tab-pane fade active in" id="tabpanel">
              <div class="row">
                <div class="col-xs-12">
                  <h3>
                    <?php the_field('news_title'); ?>
                  </h3>
                  <p>
                    <?php the_field('news_text'); ?>
                  </p>
                </div>
              </div>
            </div>
          </div> -->
        </div>
      </div>
    </div>
  </div>
</header>
<div class="scrollinghere"></div>
<?php $autoplay = $attributes['autoplay']; ?>
<script>
        (function() {
            jQuery(document).ready(function () {


                <?php if ( ( $autoplay ) && ($autoplay != 0 )) : ?>

                function startCarousel() {
                    tabCarousel = setInterval(function () {
                        var active = tabs.filter('.active');
                        var next = active.next('li').length? active.next('li').find('a') : tabs.filter(':first-child').find('a');
                        next.trigger('click');
                    }, <?php echo esc_html( $autoplay );?>);
                }

                jQuery('.quickcategories .nav-tabs li a').on('mouseover', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('.quickcategories .nav-tabs li a').on('mouseleave', function () {
                    startCarousel();
                });

                jQuery('#top-menu-collapse').on('show.bs.collapse', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('#top-menu-collapse').on('hide.bs.collapse', function () {
                    startCarousel();
                });
                startCarousel();
                <?php endif; ?>

            });
        })();
    </script>
<?php endif; ?>
