<?php /**
 * ps_vc_section_welcome_header_template.php
 *
 * Visual Composer Pistacia Section Welcome Header template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

$attributes = ( shortcode_atts( array(
    'autoplay' => 500,
    'more_button_text' => esc_html__('More','pistacia')
), $atts ) ); ?>

<?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
<?php $items = $pistacia_helpers->get_shortcodes_array('ps_vc_welcome_header_item',$content);?>

<?php if (!empty($items)): ?>

    <header class="header welcome-header-wrapper">
        <div class="welcome-header" id="welcomeHeader">
            <div class="overlay overlay-black-40"></div>
            <div class="welcome-img-slider">
                <ul class="slides clearfix">
                    <?php foreach($items as $item) : ?>
                        <?php $big_src = ( $item['big_img'] !='' ) ? wp_get_attachment_image_src( (int)$item['big_img'], 'full') : null; ?>
                        <li style="background-image:url('<?php echo esc_url($big_src[0]); ?>');"></li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="welcome-inner">
                <div class="container">
                    <div class="text-slider welcome-flexslider">
                        <ul class="slides">
                            <?php foreach($items as $item) : ?>
                                <li class="text-center">
                                    <?php if (!empty($item['textslider_title'])) : ?>
                                        <?php echo esc_html($item['textslider_title']);?>
                                    <?php endif; ?>
                                    <?php if (!empty($item['textslider_title_bold'])) : ?>
                                        <span class="extra-bold"><?php echo esc_html($item['textslider_title_bold']);?></span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="text-center">
                        <a
                            href=".scrollinghere"
                            class="btn btn-transparent hvr-shutter-out-horizontal scroll-to center-block">
                            <?php if( !empty( $attributes['more_button_text'] ) ) : ?>
                                <?php echo esc_html( $attributes['more_button_text'] ); ?>
                            <?php endif; ?>
                        </a>
                    </div>
                    <div role="tabpanel" class="quickcategories clearfix">
                        <ul class="nav nav-tabs" role="tablist">
                            <?php $count = 0; ?>
                            <?php foreach($items as $item) : ?>
                                <li role="presentation"<?php echo ( $count == 0 ? ' class="active"' : '');?>>
                                    <a href="#tabpanel-<?php echo $count; ?>" aria-controls="tabpanel-<?php echo $count; ?>" role="tab" data-toggle="tab" class="flexslider-to" data-flexslide="<?php echo $count; ?>">
                                        <?php ( empty($item['type'])) ? $item['type'] = 'fontawesome' : $item['type']; ?>
                                        <?php if ( $item['type'] == 'iconphoto' ) {?>
                                            <?php $icon_src = ( !empty($item['iconphoto']) ) ? wp_get_attachment_image_src( $item['iconphoto'], 'thumbnail') : null; ?>
                                            <?php if (!empty($icon_src)) : ?>
                                                <img src="<?php echo esc_url($icon_src[0]);?>" class="img-responsive">
                                            <?php endif; ?>
                                        <?php } else {?>
                                            <?php vc_icon_element_fonts_enqueue( $item['type'] ); ?>
                                            <?php $icon = $item['icon_'.$item['type']]; ?>
                                            <i class="<?php echo(esc_attr($icon)); ?>"></i>
                                        <?php } ?>
                                        <?php if(!empty($item['icon_text'])):?>
                                            <span class="hidden-xs"><?php echo esc_html($item['icon_text']);?></span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <?php $count++; ?>
                            <?php endforeach; ?>
                        </ul>
                        <div class="tab-content ">
                            <?php $count = 0; ?>
                            <?php foreach($items as $item) : ?>
                                <div role="tabpanel" class="tab-pane fade<?php if( $count == 0 ){ echo ' active in'; } ?>" id="tabpanel-<?php echo $count; ?>">
                                    <div class="row">
                                        <div class="col-xs-5"> test
                                            <?php if ( !empty( $item['link']) ){ echo '<a href="'.esc_url($item['link']).'">'; } ?>
                                            <?php $small_src = ( $item['small_img'] !='' ) ? wp_get_attachment_image_src( (int)$item['small_img'], 'full') : null; ?>
                                            <?php if ( !empty( $small_src ) ):?>
                                                <img src="<?php echo esc_url($small_src[0]); ?>" class="img-responsive" alt="">
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['link'] ) ){ echo '</a>'; } ?>
                                        </div>
                                        <div class="col-xs-7">
                                            <?php if ( !empty( $item['title']) ):?>
                                                <h3><?php echo esc_html($item['title']);?></h3>
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['excerpt']) ):?>
                                                <p><?php echo esc_html($item['excerpt']);?></p>
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['price']) ):?>
                                                <span class="label label-danger label-lg price-label"><?php echo esc_html($item['price']);?></span>
                                            <?php endif; ?>
                                            <?php if ( !empty( $item['link']) ):?>
                                                <?php $link = vc_build_link( $item['link'] ); ?>
                                                <?php if ( !empty($link['url'])) : ?>
                                                    <a class="" href="<?php echo esc_url($link['url']);?>" target="<?php if( !empty($link['target']) ) { echo esc_attr($link['target']); } ?>">
                                                        <i class="fa fa-chevron-right"></i>
                                                        <?php if(!empty($item['more_button_text'])) : ?>
                                                            <?php echo esc_html($item['more_button_text']); ?>
                                                        <?php else : ?>
                                                            <?php esc_html_e('More','pistacia'); ?>
                                                        <?php endif; ?>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <?php $count++; ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <div class="scrollinghere"></div>

    <?php $autoplay = $attributes['autoplay']; ?>

    <script>
        (function() {
            jQuery(document).ready(function () {

                var tabCarousel = '';
                var tabs = jQuery('.quickcategories .nav-tabs > li');

                if(document.querySelector('.welcome-img-slider')) {
                    jQuery('.welcome-img-slider').flexslider({
                        animation: "fade",
                        controlNav: false,
                        directionNav: false,
                        touch: true,
                        slideshow: false,
                        startAt: 0,
                        direction: "horizontal"
                    });
                }

                if (jQuery('.text-slider').length){
                    jQuery('.text-slider').flexslider({
                        animation: "slide",
                        controlNav: false,
                        directionNav: false,
                        touch: true,
                        slideshow: false,
                        direction: "vertical"
                    });
                }

                if(document.querySelector('.flexslider-to')) {
                    jQuery('.flexslider-to').on('click', function () {
                        if (document.querySelector('.welcome-img-slider')) {
                            jQuery('.welcome-img-slider').flexslider(jQuery(this).data('flexslide'));
                            jQuery('.text-slider').flexslider(jQuery(this).data('flexslide'));
                        }
                    });
                }

                <?php if ( ( $autoplay ) && ($autoplay != 0 )) : ?>

                function startCarousel() {
                    tabCarousel = setInterval(function () {
                        var active = tabs.filter('.active');
                        var next = active.next('li').length? active.next('li').find('a') : tabs.filter(':first-child').find('a');
                        next.trigger('click');
                    }, <?php echo esc_html( $autoplay );?>);
                }

                jQuery('.quickcategories .nav-tabs li a').on('mouseover', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('.quickcategories .nav-tabs li a').on('mouseleave', function () {
                    startCarousel();
                });

                jQuery('#top-menu-collapse').on('show.bs.collapse', function () {
                    clearInterval(tabCarousel);
                });

                jQuery('#top-menu-collapse').on('hide.bs.collapse', function () {
                    startCarousel();
                });
                startCarousel();
                <?php endif; ?>

            });
        })();
    </script>

<?php endif; ?>

