<?php
/**
 * ps_vc_section_specialties_template.php
 *
 * Visual Composer Pistacia Specialties Section
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts( array(
    'title_light' => '',
    'title_bold' => '',
    'type' => 'fontawesome',
    'icon_fontawesome' => '',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypo' => '',
    'icon_linecons' => '',
    'icon_monosocial'=> '',
    'excerpt' => '',
    'big_photo' => '',

    'first_item_icon' => '',
    'first_item_title' => '',
    'first_item_photo' => '',
    'first_item_price' => '',
    'first_item_url' => '',

    'second_item_icon' => '',
    'second_item_title' => '',
    'second_item_photo' => '',
    'second_item_price' => '',
    'second_item_url' => '',

    'third_item_icon' => '',
    'third_item_title' => '',
    'third_item_photo' => '',
    'third_item_price' => '',
    'third_item_url' => '',

),$atts );

if ($attributes['type'] != ''){
    vc_icon_element_fonts_enqueue( $attributes['type'] );
    $icon = $attributes['icon_'.$attributes['type']];
}

?>

<section class="specialties pistacia-vc-specialties" id="specialties">

    <div class="container">

        <div class="specialties-wrapper">

            <div class="left-photo">

                <div class="inner">

                    <?php $big_img = ( $attributes['big_photo'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['big_photo'], 'full') : null; ?>
                    <?php if ( !empty($big_img) ) : ?>
                        <img src="<?php echo esc_url( $big_img[0] ); ?>" class="img-responsive" alt="">
                    <?php endif; ?>

                </div>

            </div>

            <div class="right-text">

                <div class="inner">

                    <?php if ( $attributes['title_light'] != '' ) : ?>
                        <h1 class="text-center"><?php echo esc_html( $attributes['title_light'] );?>
                        <?php if ( $attributes['title_bold'] != '' ) : ?>
                            <span class="extra-bold"><?php echo esc_html( $attributes['title_bold'] );?></span></h1>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if ( $attributes['excerpt'] != '' ) : ?>
                        <p class="text-center">
                            <?php echo esc_html( $attributes['excerpt'] ); ?>
                        </p>
                    <?php endif; ?>

                    <?php if (!empty($icon)) : ?>
                        <div class="zigzag"><i class="<?php echo esc_attr($icon);?>"></i></div>
                    <?php endif; ?>

                    <?php if( $attributes['first_item_photo'] || $attributes['second_item_photo'] || $attributes['third_item_photo'] ) : ?>

                        <?php $items = array('first','second','third');?>

                        <div class="row">

                            <?php foreach ($items as $m) : ?>

                                <div class="card col-sm-4">
                                    <div class="card__front">
                                        <div class="content text-center">
                                                                                    <?php $icon = ( $attributes[$m.'_item_icon'] !='' ) ? wp_get_attachment_image_src( (int)$attributes[$m.'_item_icon'], 'thumbnail') : null; ?>

                                          <?php if (!empty($attributes[$m.'_item_url'])) : ?>
                                                <?php $link = vc_build_link($attributes[$m.'_item_url']); ?>
                                                <?php if ( !empty($link['url'])) : ?>
                                                    <a href="<?php echo esc_url($link['url']);?>" target="<?php echo esc_attr($link['target']);?>"></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            
                                           <a href="<?php echo esc_url($link['url']);?>"><span class="label label-success label-lg"><?php echo esc_html( $attributes[$m.'_item_price'] ); ?></span></a>
                                        </div>
                                    </div>

                               
                                </div>

                            <?php endforeach; ?>


                        </div>

                    <?php endif; ?>

                </div>

            </div>

        </div>

    </div>

</section>
