<?php
/**
 * ps_vc_section_services_boxes_item_template.php
 *
 * Visual Composer Pistacia Services Boxes Item template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(
    'type' => 'fontawesome',
    'icon_fontawesome' => '',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypo' => '',
    'icon_linecons' => '',
    'icon_monosocial'=> '',
    'icon_color' =>'',
    'title' => '',
    'excerpt' => ''
),$atts); ?>

<?php if ($attributes['type'] != ''){
    vc_icon_element_fonts_enqueue( $attributes['type'] );
    $icon = $attributes['icon_'.$attributes['type']];
} ?>

<?php $icon_class = 'icon-circle'; ?>
<?php $icon_class .= ( empty( $icon_color ) ) ? ' gray-bg' : ''; ?>
<?php $icon_class .= (!empty($icon)) ? ' ' . $icon : ''; ?>

<?php $icon_style = ' style="';?>
<?php $icon_style .= (!empty($attributes['icon_color'])) ? 'background-color:'.$attributes['icon_color'].';' : '' ;?>
<?php $icon_style .= '"';?>

<div class="col-md-4 item">

    <?php if(!empty($icon)) : ?>
        <i class="<?php echo esc_attr($icon_class);?>"<?php echo wp_kses_post($icon_style);?>></i>
    <?php endif; ?>

    <?php if(!empty($attributes['title'])) : ?>
        <h3 class="text-center"><?php echo esc_html( $attributes['title'] ); ?></h3>
    <?php endif; ?>

    <?php if(!empty($attributes['excerpt'])) : ?>
        <p class="text-center"><?php echo esc_html( $attributes['excerpt'] ); ?></p>
    <?php endif; ?>

</div>
