<?php
/**
 * ps_vc_section_reservation_form_template.php
 *
 * Visual Composer Pistacia Reservation Form
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(
    'decor_photo' => '',
    'calendar_hide' => false,
    'reservation_times' => ''
),$atts ); ?>

<section class="reservation-section">

    <div id="reservation">

        <div class="overlay overlay-black-90"></div>

        <?php $decorphoto = ( $attributes['decor_photo'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['decor_photo'], 'thumbnail') : null; ?>

        <?php if ( !empty( $decorphoto ) ) : ?>
            <div class="plate"><img src="<?php echo esc_url( $decorphoto[0] );?>" class="img-responsive" alt=""></div>
        <?php else : ?>
            <div class="plate"><img src="<?php echo esc_url( get_template_directory_uri() );?>/assets/img/decor.png" alt=""></div>
        <?php endif; ?>

        <div class="container container-inner">

            <?php Pistacia_Ajax_Forms::the_reservation_form(array(
                    'calendar_hide' => $attributes['calendar_hide'],
                    'reservation_times' => $attributes['reservation_times']
                )
            ); ?>

        </div>

    </div>

</section>
