<?php
/**
 * ps_vc_section_recipes_slider_template.php
 *
 * This file contains recipe slider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */ ?>

<?php $attributes = ( shortcode_atts( array(
    'post_type' => 'pistacia-recipes',
    'posts_per_page' => '5',
    'orderby' => 'date',
    'sort' => 'ASC',
    'background' => '',
), $atts ) ); ?>

<?php $args = array(
    'post_type' => $attributes['post_type'],
    'posts_per_page' => $attributes['posts_per_page'],
    'orderby' => $attributes['orderby'],
    'order'   => $attributes['sort'],
); ?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <?php $src= wp_get_attachment_image_src($attributes['background'], 'full'); ?>

    <?php $loop = new WP_Query( $args ); ?>

    <?php if( $loop->have_posts() ) : ?>

        <section class="recipes-slider-section" style="background-image:url('<?php echo esc_url($src[0]);?>');">
            <div class="recipes-slider-section-inner">
                <div class="container">
                    <div class="recipe-slider-wrapper">
                        <div class="swiper-container recipes-header-swiper-container">

                            <div class="swiper-wrapper">

                                <?php while( $loop->have_posts() ) : $loop->the_post(); ?>

                                    <?php $photo_src = wp_get_attachment_image_src(get_post_thumbnail_id( $loop->get_the_ID() ), 'large'); ?>

                                    <div class="swiper-slide">
                                        <div class="recipe-slide-wrapper">
                                            <div class="recipe-photo" style="background-image:url('<?php echo esc_url($photo_src[0]);?>');"></div>
                                            <div class="recipe-content">
                                                <div class="recipe-content-inner">
                                                    <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                                                    <div class="clearfix">
                                                        <?php if ( get_field('pistacia_recipe_author_photo')) : ?>
                                                            <?php $author_img_src = get_field('pistacia_recipe_author_photo'); ?>
                                                            <img src="<?php echo esc_url( $author_img_src['sizes']['thumbnail'] ); ?>" class="recipe-author-photo img-responsive img-circle" alt="">
                                                        <?php endif; ?>
                                                        <?php if ( get_field('pistacia_recipe_author')) : ?>
                                                            <span class="recipe-author-name"><?php esc_html_e('by','pistacia');?>: <?php the_field('pistacia_recipe_author'); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <div class="excerpt"><?php the_excerpt();?></div>
                                                    <?php if ( get_field('pistacia_recipe_skill')) : ?>
                                                        <div class="difficulty">
                                                            <?php $icon = ( function_exists('get_field') && get_field('pistacia_o_recipes_diff_symbol','option')  ) ? get_field('pistacia_o_recipes_diff_symbol','option') : 'flaticon-meal2'; ?>
                                                            <?php esc_html_e('Difficulty','pistacia');?>:
                                                            <?php for( $a=1; $a<= 5; $a++ ) : ?>
                                                                <i class="<?php echo esc_attr($icon);?><?php echo ( $a <= (int)get_field('pistacia_recipe_skill')) ? ' active' : ''; ?>"></i>
                                                            <?php endfor; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                    <a href="<?php the_permalink();?>" class="btn btn-more"><?php esc_html_e('More','pistacia');?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                <?php endwhile; ?>

                            </div>

                            <?php if ( $loop->post_count > 1 ) : ?>
                                <div class="recipes-header-swiper-button-prev"><i class="fa fa-angle-left"></i></div>
                                <div class="recipes-header-swiper-button-next"><i class="fa fa-angle-right"></i></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php endif; ?>

    <?php wp_reset_postdata(); ?>

<?php endif; ?>
