<?php
/**
 * ps_vc_section_cuote_carousel_template.php
 *
 * Visual Composer Pistacia Quote carousel
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(
    'title_light' => '',
    'title_bold' => '',
    'bg_img' => ''
),$atts );?>

<?php $bg_src = ( $attributes['bg_img'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['bg_img'], 'full') : null; ?>

<section class="quote-carousel-section"

    <?php if (!empty($bg_src)) : ?>
        style="background-image:url('<?php echo esc_url( $bg_src[0] );?>');"
    <?php endif; ?>>

    <div class="overlay overlay-black-70"></div>
    <div class="container-inner">
        <div class="container">

            <?php if ( $attributes['title_light'] != '' || $attributes['title_bold'] != '' ) : ?>
                <div class="row">
                    <div class="col-md-6 col-md-push-3">

                        <h1 class="text-center section-title">
                            <?php if ( $attributes['title_light'] !='' ) : ?>
                                <span class="light"><?php echo esc_html( $attributes['title_light'] );?></span>
                            <?php endif; ?>
                            <?php if ( $attributes['title_bold'] ) : ?>
                                <span class="extra-bold"><?php echo esc_html( $attributes['title_bold'] );?></span>
                            <?php endif; ?>
                        </h1>

                    </div>
                </div>
            <?php endif; ?>

            <?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
            <?php $testimonals = $pistacia_helpers->get_shortcodes_array('ps_vc_section_quote_carousel_item',$content);?>

            <?php if ( count($testimonals) > 0 ) : ?>
                <div class="testimonal-swiper-container swiper-container">
                    <div class="swiper-wrapper">
                        <?php foreach ( $testimonals as $item ) : ?>
                            <div class="swiper-slide">
                                <?php if (!empty($item['excerpt'])) : ?>
                                    <p class="testimonal-text text-center"><?php echo esc_html( $item['excerpt'] );?></p>
                                <?php endif; ?>
                                <?php if (!empty($item['name'])) : ?>
                                    <div class="text-center">
                                        <span class="testimonal-name text-center"><?php echo esc_html( $item['name'] );?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <?php if ( count($testimonals) > 1 ) : ?>
                        <div class="swiper-pagination testimonal-swiper-pagination"></div>
                    <?php endif; ?>

                </div>
            <?php endif; ?>

        </div>
    </div>
</section>
