<?php /**
 * ps_vc_section_top_navigation_template.php
 *
 * Visual Composer Pistacia Section Top Navigation template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

$attributes = ( shortcode_atts( array(
    'nav_align' => 'navbar-right',
    'nav_logo' => '',
    'nav_size' => 'fixed',
    'nav_fixed' => '',
    'nav_menu' => 'top-menu',
    'nav_style' => 'light',
    'nav_opacity' => 'no_opacity'
), $atts ) ); ?>

<?php $logo_src = ( $attributes['nav_logo'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['nav_logo'], 'full') : null; ?>

<?php $nav_class = 'pistacia-top-navigation';
$nav_class .= ' ' . $attributes['nav_style'];
( empty($attributes['nav_fixed']) ) ? $nav_class .= ' vc-no-fixed-menu' : $nav_class .= '';
( $attributes['nav_opacity'] == 'no-opacity' ) ? $nav_class .= ' no_opacity' : $nav_class .= ' '. $attributes['nav_opacity'] ; ?>

<section id="<?php echo (!empty($attributes['nav_fixed'])) ? 'pistacia-top-navigation' : '';?>"
         class="<?php echo esc_attr( $nav_class );?>">

    <nav class="navbar navbar-pistacia">
        <div class="container<?php echo ($attributes['nav_size'] == 'fluid') ? '-fluid' : '' ;?>">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#top-menu-collapse" aria-expanded="false">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="sr-only"><?php esc_html_e('Toggle navigation','pistacia');?></span>
                </button>

                <?php pistacia_the_mobile_cart(); ?>

                <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <?php if(!empty($logo_src)) : ?>
                        <img class="responsive" src="<?php echo esc_url($logo_src[0]);?>" alt="">
                        <?php else : ?>
                        <?php pistacia_the_brand_logo();?>
                    <?php endif; ?>
                </a>

            </div>

            <div class="collapse navbar-collapse " id="top-menu-collapse">

                <ul id="top-icons" class="nav navbar-nav navbar-right hidden-xs">
                    <li>
                        <a href="#" id="desktopSearchButton"><i class="fa fa-search"></i></a>
                    </li>
                    <?php Pistacia_Woocommerce::the_cart();?>
                </ul>

                <?php wp_nav_menu( array(
                        'menu'              => esc_html($attributes['nav_menu']),
                        'depth'             => 3,
                        'container'         => 'ul',
                        'container_class'   => 'collapse navbar-collapse',
                        'container_id'      => 'top-menu-collapse',
                        'menu_class'        => "nav navbar-nav top-menu " . esc_html($attributes['nav_align']),
                        'fallback_cb'       => 'Pistacia_Bootstrap_Navwalker::fallback',
                        'walker'            => new Pistacia_Bootstrap_Navwalker())
                ); ?>

                <div class="visible-xs mobile-search">
                    <?php pistacia_search_form_mobile();?>
                </div>

            </div>

            <div class="desktop-search" id="desktopSearch">
                <?php pistacia_search_form();?>
            </div>

        </div>
    </nav>

</section>
