<?php
/**
 * ps_vc_section_logo_slider_template.php
 *
 * Visual Composer Pistacia Logo SLider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(
    'logo_img' => '',
    'logo_link' => ''
),$atts);?>

<?php if ($attributes['logo_img']) : ?>

    <?php $link = vc_build_link( $attributes['logo_link'] ); ?>

    <div class="swiper-slide">

        <?php if ( !empty($link['url'])) : ?><a href="<?php echo esc_url($link['url']);?>" target="<?php if ( !empty($link['target'])) { echo esc_attr($link['target']);}?>"><?php endif; ?>

            <?php $logo_src = ( !empty($attributes['logo_img']) ) ? wp_get_attachment_image_src( (int)$attributes['logo_img'], 'full') : null; ?>
            <?php if( !empty($logo_src) ) : ?>
                <img src="<?php echo esc_url($logo_src[0]);?>" class="img-responsive" alt=""/>
            <?php endif; ?>
            
        <?php if( !empty($link['url']) ) : ?></a><?php endif; ?>

    </div>

<?php endif; ?>