<?php
/**
 * ps_vc_section_lead_template.php
 *
 * Visual Composer Pistacia Section Lead template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

$attributes = ( shortcode_atts( array(
    'titlelight' => '',
    'titlebold' => '',
    'lead' => '',
    'lead_wide' => '',
    'type' => 'none',
    'icon_fontawesome' => '',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypo' => '',
    'icon_linecons' => '',
    'icon_monosocial'=> ''
), $atts ) );

if ($attributes['type'] != 'none'){
    vc_icon_element_fonts_enqueue( $attributes['type'] );
    $icon = $attributes['icon_'.$attributes['type']];
} ?>

<section class="lead-section">

        <h1 class="text-center">
            <?php if ( !empty($attributes['titlelight']) ) : ?>
                <span class="light"><?php echo esc_html( $attributes['titlelight'] );?></span>
            <?php endif; ?>

            <?php if ( !empty($attributes['titlebold']) ) : ?>
                <span class="extra-bold"><?php echo esc_html( $attributes['titlebold'] );?></span>
            <?php endif; ?>
        </h1>

        <?php if ( !empty($icon) ) : ?>
            <div class="zigzag"><i class="<?php echo esc_html( $icon );?>"></i></div>
            <?php else : ?>
            <div class="zigzag-full"></div>
        <?php endif; ?>

        <?php if ( !empty( $attributes['lead'] ) ) : ?>
            <div class="row">
                <div class="<?php echo (!empty( $attributes['lead_wide']) ) ? 'col-md-12' : 'col-md-offset-3 col-md-6';?>">
                    <p class="text-center lead"><?php echo esc_html( $attributes['lead'] );?></p>
                </div>
            </div>
        <?php endif; ?>

</section>