<?php
/**
 * ps_vc_section_isotope_posts.php
 *
 * Visual Composer Pistacia Isotope Posts Template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.3
 */

$attributes = shortcode_atts(array(
    'posts_per_page' => '4',
    'filter_tabs' => ''
),$atts); ?>

<section class="isotope-posts-section pinterest-blog">

    <div class="isotope-posts-section-inner">

        <div class="container">

            <?php if ( !empty($attributes['filter_tabs']) ) : ?>

                <?php $cats = get_categories( array(
                    'orderby' => 'name'
                ) ); ?>

                <div class="text-center">

                    <ul class="list-tabs posts-filters">

                        <li class="active"><a data-filter="*" href="#">All</a></li>

                        <?php foreach( $cats as $term ){?>
                            <li><a data-filter=".<?php echo esc_html($term->slug); ?>" href="#"><?php echo esc_html( $term->slug ); ?></a></li>
                        <?php } ?>

                    </ul>

                </div>

            <?php endif; ?>

            <div class="row">

                <div class="pistacia-isotopes" data-post-per-page="<?php echo esc_attr($attributes['posts_per_page']);?>">

                    <div class="isotope-grids" id="isotope-grids"></div>

                    <div class="item-loading center-block text-center">
                        <img src="<?php echo Pistacia_Helpers::get_template_directory_uri();?>/assets/img/loader_grey.gif">
                    </div>

                </div>

            </div>

        </div>

    </div>

</section>

<section class="more-button-section">
    <div class="text-center">
        <a href="#"
           class="btn btn-append more-posts-button tool-tip"
           id="more-post-button"
           data-paged="1"
           data-toggle="tooltip"
           data-placement="top"
           data-original-title="<?php esc_attr_e('More posts','pistacia');?>">
            <i class="fa fa-angle-down"></i>
        </a>
    </div>
</section>
