<?php
/**
 * ps_vc_section_gmaps_template.php
 *
 * Visual Composer Pistacia Google Maps
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(
    'lat' => '35.370514',
    'lng' => '-97.441811',
    'zoom' => '16',
    'map_height' => '400'
), $atts); ?>

<section
    style="height:<?php echo esc_attr($attributes['map_height']);?>px"
    class="pistacia-google-maps google-maps"
    id="map-canvas"
    data-lat="<?php echo esc_attr( $attributes['lat'] );?>"
    data-lng="<?php echo esc_attr( $attributes['lng'] );?>"
    data-zoom="<?php echo esc_attr( $attributes['zoom'] );?>">

    <?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
    <?php $items = $pistacia_helpers->get_shortcodes_array('ps_vc_section_gmaps_marker',$content);?>

    <?php if (!empty($items)) : ?>

        <?php foreach( $items as $marker ) : ?>

            <?php if ( !empty($marker['marker_lng']) && !empty($marker['marker_lat']) ) : ?>
                <div class="marker"
                     data-text="<?php echo (!empty($marker['marker_content'])) ? esc_html( $marker['marker_content'] ) : ''; ?>"
                     data-lat="<?php echo esc_attr( $marker['marker_lat'] ); ?>"
                     data-lng="<?php echo esc_attr( $marker['marker_lng'] ); ?>">
                </div>
            <?php endif; ?>

        <?php endforeach; ?>

    <?php endif; ?>
</section>
