<?php /**
 * ps_vc_section_footer_copyright_template.php
 *
 * Visual Composer Pistacia Section Footer copyright template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

$attributes = ( shortcode_atts( array(

    'copyright' => '',
    'bottom_menu' => 'default'

), $atts ) ); ?>

<section class="bottom-bar" id="bottomBar">

    <a href="#pageTop" class="btn btn-white scroll-to vc-footer-page-top"><i class="fa fa-chevron-up"></i></a>

    <div class="container">

        <?php if ( !empty($attributes['copyright']) ) : ?>
            <div class="pull-left">
                <div class=""><span class="small"><?php echo esc_html($attributes['copyright']); ?></span></div>
            </div>
        <?php endif; ?>

        <?php if ( $attributes['bottom_menu'] != 'default' ) : ?>
            <div class="pull-right">
                <?php wp_nav_menu(array(
                    'menu' => $attributes['bottom_menu'],
                    'menu_class' => 'clear bottom-menu',
                    'container' => 'ul',
                    'depth' => 1
                )); ?>
            </div>
        <?php endif; ?>

    </div>

</section>
