<?php
/**
 * ps_vc_section_counter_template.php
 *
 * Visual Composer Pistacia Counter
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */ ?>

<?php $attributes = shortcode_atts(array(
    'bg_img' => '',
    'counter_section_title_light' => '',
    'counter_section_title_bold' => ''
),$atts);?>

<section id="specialServices" class="special-services">

    <?php $bg_src = ( $attributes['bg_img'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['bg_img'], 'full') : null; ?>

    <div id="counterParallax" class="counter-parallax"
        <?php if(!empty($bg_src)) : ?>
            style="background-image:url('<?php echo esc_url($bg_src[0]); ?>')"
        <?php endif; ?>>

        <div class="overlay overlay-black-70"></div>

        <div class="container container-inner">

            <?php if(  $attributes['counter_section_title_light'] ||  $attributes['counter_section_title_bold'] ) : ?>

                <div class="quote text-center">

                    <h1 class="white-color">
                        <?php if (  !empty($attributes['counter_section_title_light']) ) : ?>
                            <span class="light"><?php echo esc_html(  $attributes['counter_section_title_light'] );?></span>
                        <?php endif; ?>

                        <?php if (  !empty($attributes['counter_section_title_bold']) ) : ?>
                            <span class="extra-bold"><?php echo esc_html(  $attributes['counter_section_title_bold'] );?></span>
                        <?php endif; ?>
                    </h1>

                </div>

            <?php endif; ?>

            <div class="counters">

                <?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
                <?php $items = $pistacia_helpers->get_shortcodes_array('ps_vc_section_counter_item',$content);?>

                <?php if (!empty($items)) : ?>

                    <?php $count = 0; ?>
                    <?php $col = (count($items) < 5) ? 12 / count($items) : '3'; ?>

                    <?php foreach ($items as $item) : ?>

                        <?php $direction = (!empty($item['counter_direction'])) ? $item['counter_direction'] : 'Left';?>

                        <div class="col-sm-<?php echo esc_attr($col); ?> col-xs-6">

                            <div class="counter text-center rotateInDown<?php echo esc_html($direction);?>-ifAppeared">

                                <?php if (!empty($item['counter_number'])) : ?>
                                    <div class="number counter-number" id="counterNumber<?php echo $count; ?>">
                                        <?php echo esc_html( $item['counter_number'] ); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($item['counter_title'])) : ?>
                                    <p><?php echo esc_html( $item['counter_title'] );?></p>
                                <?php endif; ?>

                            </div>

                        </div>

                        <?php $count++; ?>

                    <?php endforeach; ?>

                <?php endif; ?>

            </div>

        </div>

    </div>

</section>
