<?php /**
 * ps_vc_footer_testimony_item_template.php
 *
 * Visual Composer Pistacia Section Footer testimany slider item template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */
?>

<?php $attributes = ( shortcode_atts( array(
    'photo' => '',
    'testimony' => '',
    'name' => '',
    'text_color' => ''
), $atts ) ); ?>

<?php $text_style = (!empty($attributes['text_color'])) ? ' style="color:' . $attributes['text_color'] . ';"' : ''; ?>

<div class="swiper-slide">

    <div class="row">

        <?php if ( !empty($attributes['photo']) ): ?>
            <?php $photo_src = ( $attributes['photo'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['photo'], 'thumbnail') : null; ?>
            <div class="col-sm-4">
                <img class="responsive img-circle" src="<?php echo esc_url($photo_src[0]);?>" alt="">
            </div>
        <?php endif; ?>

        <div class="col-sm-<?php echo ( !empty($attributes['photo']) ) ? '8' : '12'; ?>">
            <i class="fa fa-quote-left"<?php echo wp_kses_post( $text_style );?>></i> <span<?php echo wp_kses_post( $text_style );?>><?php echo wp_kses_post($attributes['testimony']);?></span> <i class="fa fa-quote-right"<?php echo wp_kses_post( $text_style );?>></i>
            <br><br><small<?php echo wp_kses_post( $text_style );?>><?php echo wp_kses_post( $attributes['name'] );?></small>
        </div>

    </div>

</div>
