<?php $attributes = shortcode_atts(array(
    'type' => 'fontawesome',
    'icon_fontawesome' => '',
    'icon_openiconic' => '',
    'icon_typicons' => '',
    'icon_entypo' => '',
    'icon_linecons' => '',
    'icon_monosocial'=> '',
    'custom_icon' => '',
    'icon_color'=> '',
    'icon_background'=> '',
    'title' => '',
    'excerpt' => '',
    'more_button_text' => 'more',
    'link' => ''
),$atts); ?>

<?php if ($attributes['custom_icon']){
    $icon_src = ( $attributes['custom_icon'] !='' ) ? wp_get_attachment_image_src( (int)$attributes['custom_icon'], 'thumbnail') : null;
} else {
    vc_icon_element_fonts_enqueue( $attributes['type'] );
    $icon = $attributes['icon_'.$attributes['type']];
}
$icon_style = (!empty($attributes['icon_color'])) ? 'color:' . $attributes['icon_color'] . ';' : '';
$icon_style .= (!empty($attributes['icon_background'])) ? ' background-color:' . $attributes['icon_background'] . ';' : '';
?>

<div class="item swiper-slide">

    <h3>
        <?php if(!empty($icon_src)) : ?>
            <i style="<?php echo esc_attr($icon_style);?>"><img class="img-responsive" src="<?php echo esc_url( $icon_src[0] ); ?>"></i>
        <?php else : ?>
            <?php if ( !empty($icon) ) : ?>
                <i class="<?php echo esc_attr($icon); ?>" style="<?php echo esc_attr($icon_style);?>"></i>
            <?php endif; ?>
        <?php endif; ?>

        <?php if ( !empty($attributes['title']) ) : ?>
            <?php echo $attributes['title']; ?>
        <?php endif; ?>

    </h3>
    <?php if ( !empty($attributes['excerpt']) ) : ?>
        <div class="excerpt"><?php echo $attributes['excerpt']; ?></div>
    <?php endif; ?>

    <?php if ( !empty($attributes['link']) ) : ?>
        <a href="<?php echo esc_html($attributes['link']); ?>" class="btn-more hvr-icon-forward">
            <?php if ( !empty($attributes['more_button_text']) ) : ?>
                <?php echo esc_html($attributes['more_button_text']); ?>
            <?php else: ?>
                <?php esc_html_e('More', 'pistacia'); ?>
            <?php endif; ?>
        </a>
    <?php endif; ?>

</div>