<?php
/**
 * ps_vc_section_recipes_template.php
 *
 * Visual Composer Pistacia Section Recipes template
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */?>

<?php $attributes = ( shortcode_atts( array(
    'title' => esc_html__('Recipes','pistacia'),
    'perpage' => 10,
    'columns' => 5
), $atts ) ); ?>

<?php $taxonomy = '';
$current_term_id = ''; ?>

<?php global $pistacia_recipe_manager; ?>

<?php if ( !empty($pistacia_recipe_manager) ) : ?>

    <?php get_template_part( 'partials/element', 'recipe-search-bar' ); ?>

    <section class="recipe-boxes-section">
        <div class="container">
            <div
                class="recipe-boxes block-grid-<?php echo esc_attr($attributes['columns']);?>"
                id="recipe-boxes">
                <div
                    class="recipes-container"
                    id="recipes-container"
                    data-default-postperpage="<?php echo esc_attr($attributes['perpage']);?>"
                    data-default-paged="1"
                    data-termid=""
                    data-taxonomy="">
                </div>
                <div class="item-loading center-block text-center">
                    <img src="<?php echo get_template_directory_uri();?>/assets/img/loader_grey.gif">
                </div>
            </div>
        </div>
    </section>

    <section class="more-button-section">
        <div class="text-center">
            <a href="#" class="btn btn-append more-posts-button tool-tip" id="more-recipes-button" data-toggle="tooltip" data-placement="top" data-original-title="<?php esc_html_e('More recipes','pistacia');?>">
                <i class="fa fa-angle-down"></i>
            </a>
        </div>
    </section>

<?php endif; ?>
