<?php
/**
 * ps_vc_element_menus.php
 *
 * Visual Composer Pistacia Menus
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.4.0
 */
?>

<?php global $pistacia_menu_manager; ?>

<?php $attributes = shortcode_atts( array(
    'title' => '',
    'text_color' => '',
    'menu_category' => '',
    'order_by' => 'title',
    'order' => 'ASC',
    'photo_style' => 'img-circle',
    'show_photo' => false
), $atts ); ?>

<?php $the_query = new WP_Query( array(
    'post_type' => 'pistacia-menus',
    'paged' => 1,
    'posts_per_page' => -1,
    'status' => 'published',
    'orderby' => $attributes['order_by'],
    'order'   => $attributes['order'],
    'tax_query' => array(
        array(
            'taxonomy' => 'pistacia-menus-categories',
            'field'    => 'term_id',
            'terms'    => $attributes['menu_category'],
        ),
    )
) ); ?>

<?php if(!empty($pistacia_menu_manager)) : ?>

    <?php if ( $the_query->have_posts() ) : ?>

        <div class="food-menus-items">

            <?php if( !empty( $attributes['title'] ) ) : ?>
                <h3 class="title">
                    <span<?php echo ($attributes['text_color'] != '') ? ' style="color:' . $attributes['text_color'] . '"' : '';?>><?php echo esc_html($attributes['title']); ?></span>
                    <span class="line"<?php echo ($attributes['text_color'] != '') ? ' style="background-color:' . $attributes['text_color'] . '"' : '';?>></span>
                </h3>
            <?php endif; ?>

            <ul class="items">

                <?php while ( $the_query->have_posts() ) : ?>

                    <?php $the_query->the_post(); ?>

                    <?php $li_class = 'item'; ?>
                    <?php $thumb_src = wp_get_attachment_image_src(get_post_thumbnail_id( get_the_ID() ), 'thumbnail');?>
                    <?php $large_src = wp_get_attachment_image_src(get_post_thumbnail_id( get_the_ID() ), 'full');?>
                    <?php $menus_featured = get_the_terms(get_the_ID(), 'pistacia-menus-featured'); ?>

                    <?php if ( !empty($menus_featured) ){
                        $li_class .= ' active';
                    } ?>

                    <?php if (!empty($thumb_src) && !empty($attributes['show_photo']) ){
                        $li_class .= ' item-with-photo';
                    } ?>

                    <li class="<?php echo esc_attr($li_class); ?>">

                        <?php if( !empty( $attributes['show_photo'] ) ) : ?>

                            <?php if (!empty($thumb_src)) : ?>
                                <div class="photo">
                                    <a href="<?php echo esc_url($large_src[0]);?>" class="swipebox" rel="gallery-menus-<?php esc_attr($attributes['menu_category']); ?>" title="">
                                        <img src="<?php echo esc_url($thumb_src[0]);?>" class="img-responsive <?php echo $attributes['photo_style']; ?>">
                                    </a>
                                </div>
                            <?php endif; ?>

                        <?php endif; ?>

                        <div class="text-wrapper">

                            <h3>
                                <span class="name"<?php echo ($attributes['text_color'] != '') ? ' style="color:' . $attributes['text_color'] . '"' : '';?>><?php echo esc_html( get_the_title() ); ?></span>

                                <?php if( function_exists( 'get_field' ) ) {
                                    if(get_field('pistacia_menu_price') ) { ?>
                                        <span class="price"<?php echo ($attributes['text_color'] != '') ? ' style="background-color:' . $attributes['text_color'] . '"' : '';?>><?php echo esc_html(get_field('pistacia_menu_price')); ?></span>
                                    <?php }
                                } ?>
                            </h3>

                            <?php $tags = get_the_terms(get_the_ID(), 'pistacia-menus-tags'); ?>

                            <div class="clearfix">

                                <?php if (!empty($tags)) : ?>
                                    <ul class="meta pull-left">
                                        <?php foreach( $tags as $tag ) : ?>
                                            <li<?php echo ($attributes['text_color'] != '') ? ' style="color:' . $attributes['text_color'] . '"' : '';?>><?php print($tag->name);?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>

                                <?php if (!empty($menus_featured)) : ?>
                                    <ul class="featured pull-right">
                                        <?php foreach( $menus_featured as $featured ) : ?>
                                            <li<?php echo ($attributes['text_color'] != '') ? ' style="color:' . $attributes['text_color'] . '"' : '';?>><?php print($featured->name);?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>

                            </div>

                        </div>

                    </li>

                <?php endwhile; ?>

            </ul>

        </div>

    <?php endif; ?>

    <?php wp_reset_postdata(); ?>

<?php endif; ?>
