<?php
/**
 * ps_vc_element_menu_cards_item.php
 *
 * Visual Composer Pistacia Menu Cards
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */?>

<?php $attributes = shortcode_atts(array(),$atts );?>

<?php $pistacia_helpers = Pistacia_Helpers::get_instance(); ?>
<?php $items = $pistacia_helpers->get_shortcodes_array('ps_vc_element_menu_cards_item',$content); ?>

<?php if ( count($items) > 0 ) : ?>

    <section class="menu-cards" id="menuCards">

        <div class="container">

            <div class="menucard-boxes">

                <?php foreach ( $items as $item ) : ?>

                    <?php $url = (!empty($item['card_link'])) ? vc_build_link( $item['card_link'] ) : null; ?>

                    <div class="menucard-box item hvr-float-shadow">

                        <div class="container-inner clearfix">

                            <div class="row">

                                <div class="col-md-4">
                                    <figure>
                                        <?php $img_src = ( !empty($item['image']) ) ? wp_get_attachment_image_src( (int)$item['image'], 'medium') : null; ?>
                                        <?php if ( !empty($img_src) ) : ?>
                                            <img src="<?php echo esc_url($img_src[0]);?>" class="img-responsive" alt="">
                                        <?php endif; ?>
                                    </figure>

                                </div>

                                <div class="col-md-8">

                                    <div class="item-detail">

                                        <h4 class="product-name">
                                            <a href="<?php if (!empty($url)) { echo esc_url($url['url']); } ?>" target="<?php if (!empty($url)) { echo esc_attr($url['target']); } ?>">
                                                <?php if (!empty($item['title'])) : ?>
                                                    <?php echo esc_html($item['title']);?>
                                                <?php endif; ?>
                                            </a>
                                        </h4>

                                        <?php if (!empty($item['excerpt'])) : ?>
                                            <p><?php echo esc_html($item['excerpt']);?></p>
                                        <?php endif; ?>

                                        <?php $ratings = (!empty($item['ratings'])) ? (int)$item['ratings'] : 1; ?>
                                        <?php pistacia_the_stars( $ratings ); ?>

                                    </div>

                                </div>

                            </div>

                            <div class="row">

                                <div class="col-md-12">

                                    <a href="<?php if (!empty($url)) { echo esc_url($url['url']); } ?>" target="<?php if (!empty($url)) { echo esc_attr($url['target']); } ?>" class="btn btn-primary">
                                        <?php if (!empty($item['price'])) : ?>
                                            <?php echo esc_html($item['price']);?>
                                        <?php endif; ?>
                                    </a>

                                </div>

                            </div>

                        </div>

                    </div>

                <?php endforeach; ?>

            </div>

        </div>

    </section>


<?php endif; ?>
