<?php
/**
 * ps_vc_section_specialties.php
 *
 * Visual Composer Pistacia Specialties Section
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_specialties() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Specialties', 'pistacia' ),
        'base'                    => 'ps_vc_section_specialties',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Show specialties section', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_specialties_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view' => 'VcIconElementView_Backend',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Specialties Title light','pistacia'),
                'param_name' => 'title_light',
                'description' => esc_html__( 'Title light', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Specialties Title bold','pistacia'),
                'param_name' => 'title_bold',
                'description' => esc_html__( 'Title bold', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Icon library', 'pistacia' ),
                'value' => array(
                    esc_html__( 'Font Awesome', 'pistacia' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'pistacia' ) => 'openiconic',
                    esc_html__( 'Typicons', 'pistacia' ) => 'typicons',
                    esc_html__( 'Entypo', 'pistacia' ) => 'entypo',
                    esc_html__( 'Linecons', 'pistacia' ) => 'linecons',
                    esc_html__( 'Mono Social', 'pistacia' ) => 'monosocial',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_fontawesome',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontawesome',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_openiconic',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'openiconic',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_typicons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'typicons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_entypo',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'entypo',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_linecons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'linecons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_monosocial',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'monosocial',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'monosocial',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'textarea',
                'value' => '',
                'heading' =>  esc_html__('Specialties excerpt','pistacia'),
                'param_name' => 'excerpt',
                'description' => esc_html__( 'Excerpt', 'pistacia' )
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Specialties big photo','pistacia'),
                'param_name' => 'big_photo',
                'description' => esc_html__( 'Photo left or right. 630x950 pixel', 'pistacia' )
            ),

            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item icon','pistacia'),
                'param_name' => 'first_item_icon',
                'description' => esc_html__( 'Upload png from flaticon.com 512x512 pixel', 'pistacia' ),
                'group' => esc_html__('First item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item title','pistacia'),
                'param_name' => 'first_item_title',
                'description' => esc_html__( 'Item title', 'pistacia' ),
                'group' => esc_html__('First item','pistacia'),
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item photo','pistacia'),
                'param_name' => 'first_item_photo',
                'description' => esc_html__( 'Item photo', 'pistacia' ),
                'group' => esc_html__('First item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item price','pistacia'),
                'param_name' => 'first_item_price',
                'description' => esc_html__( 'Item price', 'pistacia' ),
                'group' => esc_html__('First item','pistacia'),
            ),
            array(
                'type' => 'vc_link',
                'value' => '',
                'heading' =>  esc_html__('Item link','pistacia'),
                'param_name' => 'first_item_url',
                'description' => esc_html__( 'Item link', 'pistacia' ),
                'group' => esc_html__('First item','pistacia'),
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item icon','pistacia'),
                'param_name' => 'second_item_icon',
                'description' => esc_html__( 'Upload png from flaticon.com 512x512 pixel', 'pistacia' ),
                'group' => esc_html__('Second item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item title','pistacia'),
                'param_name' => 'second_item_title',
                'description' => esc_html__( 'Item title', 'pistacia' ),
                'group' => esc_html__('Second item','pistacia'),
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item photo','pistacia'),
                'param_name' => 'second_item_photo',
                'description' => esc_html__( 'Item photo', 'pistacia' ),
                'group' => esc_html__('Second item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item price','pistacia'),
                'param_name' => 'second_item_price',
                'description' => esc_html__( 'Item price', 'pistacia' ),
                'group' => esc_html__('Second item','pistacia'),
            ),
            array(
                'type' => 'vc_link',
                'value' => '',
                'heading' =>  esc_html__('Item link','pistacia'),
                'param_name' => 'second_item_url',
                'description' => esc_html__( 'Item link', 'pistacia' ),
                'group' => esc_html__('Second item','pistacia'),
            ),


            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item icon','pistacia'),
                'param_name' => 'third_item_icon',
                'description' => esc_html__( 'Upload png from flaticon.com 512x512 pixel', 'pistacia' ),
                'group' => esc_html__('Third item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item title','pistacia'),
                'param_name' => 'third_item_title',
                'description' => esc_html__( 'Item title', 'pistacia' ),
                'group' => esc_html__('Third item','pistacia'),
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Item photo','pistacia'),
                'param_name' => 'third_item_photo',
                'description' => esc_html__( 'Item photo', 'pistacia' ),
                'group' => esc_html__('Third item','pistacia'),
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Item price','pistacia'),
                'param_name' => 'third_item_price',
                'description' => esc_html__( 'Item price', 'pistacia' ),
                'group' => esc_html__('Third item','pistacia'),
            ),
            array(
                'type' => 'vc_link',
                'value' => '',
                'heading' =>  esc_html__('Item link','pistacia'),
                'param_name' => 'third_item_url',
                'description' => esc_html__( 'Item link', 'pistacia' ),
                'group' => esc_html__('Third item','pistacia'),
            ),


        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Specialties extends WPBakeryShortCode {
        }
    }
}

add_action('vc_after_init', 'pistacia_vc_section_specialties');

