<?php
/**
 * ps_vc_section_reservation_form.php
 *
 * Visual Composer Pistacia Reservation Form
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_reservation_form() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Reservation Form', 'pistacia' ),
        'base'                    => 'ps_vc_section_reservation_form',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Show reservation form section', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_reservation_form_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'dropdown',
                'value' => array(
                    esc_html__('Show calendar','pistacia') => false,
                    esc_html__('Hide calendar','pistacia') => true,
                ),
                'heading' =>  esc_html__('Show or hide reservation form calendar','pistacia'),
                'param_name' => 'calendar_show',
                'description' => esc_html__( 'Calendar show or hide', 'pistacia' )
            ),
            array(
                'type' => 'attach_image',
                'value' => '',
                'heading' =>  esc_html__('Decor photo','pistacia'),
                'param_name' => 'decor_photo',
                'description' => esc_html__( 'Upload 170x170 pixel png', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'value' => '',
                'heading' =>  esc_html__('Type reservation time with comma separate','pistacia'),
                'param_name' => 'reservation_times',
                'description' => '12:30,13:30,14:30'
            ),
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Reservation_Form extends WPBakeryShortCode {
        }
    }
}

add_action('vc_after_init', 'pistacia_vc_section_reservation_form');

