<?php
/**
 * ps_vc_section_recipes_slider.php
 *
 * Visual Composer Pistacia Slider show
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */

function pistacia_vc_section_recipes_slider() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Recipes Slider', 'pistacia' ),
        'base'                    => 'ps_vc_section_recipes_slider',
        'category'                => esc_html__( 'Pistacia recipe', 'pistacia' ),
        'description'             => esc_html__( 'Recipe slider', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_recipes_slider_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'attach_image',
                'heading' =>  esc_html__('Slider image','pistacia'),
                'param_name' => 'background',
                'description' => esc_html__( 'Slider section background image.', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'value' => array(
                    esc_html__('header','pistacia') => 'Header'
                ),
                'heading' =>  esc_html__('Slider type','pistacia'),
                'param_name' => 'style',
                'description' => esc_html__( 'Slider type.', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'value' => '5',
                'heading' =>  esc_html__('Recipes per page','pistacia'),
                'param_name' => 'posts_per_page',
                'description' => esc_html__( 'How many recipes show in box', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'value' => array(
                    esc_html__('date','pistacia') => 'date',
                    esc_html__('title','pistacia') => 'title',
                    esc_html__('comment_count','pistacia') => 'comment_count',
                    esc_html__('modified','pistacia') => 'modified'
                ),
                'heading' =>  esc_html__('Order by','pistacia'),
                'param_name' => 'orderby',
                'description' => esc_html__( 'Order by', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'value' => array(
                    'ASC' => 'ASC',
                    'DESC' => 'DESC'
                ),
                'heading' =>  esc_html__('Sorting','pistacia'),
                'param_name' => 'sort',
                'description' => esc_html__( 'Recipes sorting ASC or DESC', 'pistacia' )
            ),
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_section_recipes_slider extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}

global $pistacia_recipe_manager;

if ( !empty($pistacia_recipe_manager) ) {
    add_action('vc_after_init', 'pistacia_vc_section_recipes_slider');
}
