<?php
/**
 * ps_vc_section_cuote_carousel.php
 *
 * Visual Composer Pistacia Quote carousel
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_quote_carousel() {
    vc_map( array(
        'name'                    => esc_html__( 'Pistacia Quote Carousel', 'pistacia' ),
        'base'                    => 'ps_vc_section_quote_carousel',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia Quote carousel', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_quote_carousel_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'content_element'         => true,
        'is_container'            => true,
        'js_view'                 => 'VcColumnView',
        'as_parent'               => array('only'=>'ps_vc_section_quote_carousel_item'),
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Background image', 'pistacia' ),
                'param_name' => 'bg_img',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title light', 'pistacia' ),
                'param_name' => 'title_light',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title bold', 'pistacia' ),
                'param_name' => 'title_bold',
                'value' => '',
                'description' => ''
            )
        )
    ) );

    vc_map( array(
        'name'                       => esc_html__('Pistacia Quote Carousel Item', 'pistacia'),
        'base'                       => 'ps_vc_section_quote_carousel_item',
        'html_template'              => '',
        'as_child'                   => array('only' => 'ps_vc_section_quote_carousel'),
        'show_settings_on_create'    => true,
        'js_view'                    => '',
        'is_container'               => false,
        'content_element'            => true,
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                     => array(
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Excerpt', 'pistacia' ),
                'param_name' => 'excerpt',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Name', 'pistacia' ),
                'param_name' => 'name',
                'value' => '',
                'description' => ''
            ),
        ),
    ) );

    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Quote_Carousel extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Quote_Carousel_Item extends  WPBakeryShortCode {
        }
    }

}
add_action('vc_after_init', 'pistacia_vc_section_quote_carousel');