<?php
/**
 * ps_vc_section_top_navigation.php
 *
 * Visual Composer Pistacia top navigation
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_navigation() {

    $settings = array(
        'name'                    => esc_html__( 'Pistacia Navigation', 'pistacia' ),
        'base'                    => 'ps_vc_section_navigation',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'You can add navigation section. Only one navigation per page to correct work.', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_navigation_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'attach_image',
                'heading' =>  esc_html__('Logo','pistacia'),
                'param_name' => 'nav_logo',
                'description' => esc_html__( 'You can overwrite default uploaded logo. Upload navigation logo. (520px x 138px).', 'pistacia' )
            ),
            array(
                'type' => 'checkbox',
                'value' => '',
                'heading' =>  esc_html__('Fixed top menu','pistacia'),
                'param_name' => 'nav_fixed',
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Navigation menu','pistacia'),
                'param_name' => 'nav_menu',
                'value' => array_merge( array(esc_html__('default','pistacia') => 'default') , pistacia_get_all_navmenus_array() ),
                'description' => esc_html__( 'Choose one menu from all your nav menus', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'value' => array(
                    esc_html__('menu align right','pistacia') => 'navbar-right',
                    esc_html__('menu align left','pistacia') => 'navbar-left',
                ),
                'heading' =>  esc_html__('Top menu align','pistacia'),
                'param_name' => 'nav_align',
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Menu size','pistacia'),
                'param_name' => 'nav_size',
                'value' => array(
                    esc_html__('fixed width','pistacia')=> 'fixed',
                    esc_html__('full width','pistacia')=> 'fluid',
                ),
                'description' => esc_html__( 'Fluid or fixed width menu', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Menu style','pistacia'),
                'param_name' => 'nav_style',
                'value' => array(
                    esc_html__('light','pistacia')=> 'light',
                    esc_html__('dark','pistacia')=> 'dark',
                    esc_html__('primary','pistacia')=> 'primary',
                ),
                'description' => esc_html__( 'Fluid or fixed width menu', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Menu opacity','pistacia'),
                'param_name' => 'nav_opacity',
                'value' => array(
                    esc_html__('no opacity','pistacia')=> 'no_opacity',
                    '10%'=> 'opacity-10',
                    '20%'=> 'opacity-20',
                    '30%'=> 'opacity-30',
                    '40%'=> 'opacity-40',
                    '50%'=> 'opacity-50',
                    '60%'=> 'opacity-60',
                    '70%'=> 'opacity-70',
                    '80%'=> 'opacity-80',
                    '90%'=> 'opacity-90',
                ),
                'description' => esc_html__( 'Opacity menu', 'pistacia' )
            ),

        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Navigation extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}
add_action('vc_after_init', 'pistacia_vc_section_navigation');
