<?php
/**
 * ps_vc_section_logo_slider.php
 *
 * Visual Composer Pistacia Logo SLider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_logo_slider() {

    vc_map( array(
            'name'                       => esc_html__( 'Pistacia Logo Slider', 'pistacia' ),
            'base'                       => 'ps_vc_section_logo_slider',
            'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
            'description'                => esc_html__( 'You can make logo slider', 'pistacia' ),
            'show_settings_on_create'    => false,
            'weight'                     => - 5,
            'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_section_logo_slider_template.php',
            'admin_enqueue_js'           => '',
            'admin_enqueue_css'          => '',
            'front_enqueue_js'           => '',
            'front_enqueue_css'          => '',
            'js_view'                    => 'VcColumnView',
            'as_parent'                  => array('only'=>'ps_vc_section_logo_slider_item'),
            'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
            'content_element'            => true,
            'is_container'               => true,
            'params'                     => array(
            )
        )
    );

    vc_map( array(
            'name'                       => esc_html__('Pistacia Slider Item', 'pistacia'),
            'base'                       => 'ps_vc_section_logo_slider_item',
            'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_section_logo_slider_item_template.php',
            'as_child'                   => array('only' => 'ps_vc_section_logo_slider'),
            'show_settings_on_create'    => true,
            'js_view'                    => '',
            'is_container'               => false,
            'content_element'            => true,
            'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
            'params'                     => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Logo image', 'pistacia' ),
                    'param_name' => 'logo_img',
                    'value' => '',
                    'description' => ''
                ),
                array(
                    'type' => 'vc_link',
                    'heading' => esc_html__( 'Link', 'pistacia' ),
                    'param_name' => 'logo_link',
                    'value' => '',
                    'description' => ''
                )
            )
        )
    );


    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Logo_Slider extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Logo_Slider_Item extends  WPBakeryShortCode {
        }
    }

}

add_action('vc_after_init', 'pistacia_vc_section_logo_slider');
