<?php
/**
 * ps_vc_section_lead.php
 *
 * Visual Composer Pistacia Page Title
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

function pistacia_vc_section_lead() {

    $settings = array(
        'name'                    => esc_html__( 'Pistacia Section Lead', 'pistacia' ),
        'base'                    => 'ps_vc_section_lead',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia section lead', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_lead_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view' => 'VcIconElementView_Backend',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Light title', 'pistacia' ),
                'param_name'  => 'titlelight',
                'description' => esc_html__( 'Type light title', 'pistacia' )
            ),
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Bold title', 'pistacia' ),
                'param_name'  => 'titlebold',
                'description' => esc_html__( 'Type bold text', 'pistacia' )
            ),
            array(
                'type'        => 'textarea',
                'heading'     => esc_html__( 'Lead text', 'pistacia' ),
                'param_name'  => 'lead',
                'description' => esc_html__( 'Type lead text', 'pistacia' )
            ),
            array(
                'type'        => 'checkbox',
                'heading'     => esc_html__( 'Lead wide', 'pistacia' ),
                'param_name'  => 'lead_wide',
                'value'       => false,
                'description' => esc_html__( 'Lead full width', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Icon library', 'pistacia' ),
                'value' => array(
                    esc_html__( 'None', 'pistacia' ) => 'none',
                    esc_html__( 'Font Awesome', 'pistacia' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'pistacia' ) => 'openiconic',
                    esc_html__( 'Typicons', 'pistacia' ) => 'typicons',
                    esc_html__( 'Entypo', 'pistacia' ) => 'entypo',
                    esc_html__( 'Linecons', 'pistacia' ) => 'linecons',
                    esc_html__( 'Mono Social', 'pistacia' ) => 'monosocial',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_fontawesome',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontawesome',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_openiconic',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'openiconic',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_typicons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'typicons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_entypo',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'entypo',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_linecons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'linecons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_monosocial',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'monosocial',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'monosocial',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
        ),
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Lead extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}

add_action('vc_after_init', 'pistacia_vc_section_lead');

