<?php
/**
 * ps_vc_section_isotope_posts.php
 *
 * Visual Composer Pistacia Isotope Posts
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.3
 */

function pistacia_vc_section_isotope_posts() {

    vc_map( array(
        'name'                       => esc_html__( 'Pistacia Isotope Posts', 'pistacia' ),
        'base'                       => 'ps_vc_section_isotope_posts',
        'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'                => esc_html__( 'You can make isotope posts', 'pistacia' ),
        'show_settings_on_create'    => true,
        'weight'                     => - 5,
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_section_isotope_post_template.php',
        'admin_enqueue_js'           => '',
        'admin_enqueue_css'          => '',
        'front_enqueue_js'           => '',
        'front_enqueue_css'          => '',
        'js_view'                    => '',
        'as_parent'                  => '',
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                     => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Posts per page', 'pistacia' ),
                'param_name' => 'posts_per_page',
                'value' => '4',
                'description' => esc_html__( 'How many post paginate per page', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Display filters', 'pistacia' ),
                'param_name' => 'filter_tabs',
                'value' => array(
                    esc_html__('Hide','pistacia') => '',
                    esc_html__('Show','pistacia') => 'show'
                ),
                'description' => esc_html__( 'Display filters', 'pistacia' )
            ),
        )
    ) );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Isotope_Posts extends  WPBakeryShortCode {
        }
    }

}

add_action('vc_after_init', 'pistacia_vc_section_isotope_posts');
