<?php
/**
 * ps_vc_section_gmaps.php
 *
 * Visual Composer Pistacia Google Maps
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_gmaps() {
    vc_map( array(
        'name'                    => esc_html__( 'Pistacia Google Mpas', 'pistacia' ),
        'base'                    => 'ps_vc_section_gmaps',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia Google maps', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_section_gmaps_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'content_element'         => true,
        'is_container'            => true,
        'js_view'                 => 'VcColumnView',
        'as_parent'               => array('only'=>'ps_vc_section_gmaps_marker'),
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Latitude', 'pistacia' ),
                'param_name' => 'lat',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Longtitude', 'pistacia' ),
                'param_name' => 'lng',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Zoom param', 'pistacia' ),
                'param_name' => 'zoom',
                'value' => '',
                'description' => esc_html__('1-20 number','pistacia')
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Map height', 'pistacia' ),
                'param_name' => 'map_height',
                'value' => '400',
                'description' => esc_html__('default value 400','pistacia')
            )
        )
    ) );

    vc_map( array(
        'name'                       => esc_html__('Pistacia Map Marker', 'pistacia'),
        'base'                       => 'ps_vc_section_gmaps_marker',
        'html_template'              => '',
        'as_child'                   => array('only' => 'ps_vc_section_gmaps'),
        'show_settings_on_create'    => true,
        'js_view'                    => '',
        'is_container'               => false,
        'content_element'            => true,
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                     => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Latitude', 'pistacia' ),
                'param_name' => 'marker_lat',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Longtitude', 'pistacia' ),
                'param_name' => 'marker_lng',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Marker content', 'pistacia' ),
                'param_name' => 'marker_content',
                'value' => '',
                'description' => ''
            )
        ),
    ) );

    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Gmaps extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Gmaps_Marker extends  WPBakeryShortCode {
        }
    }

}
add_action('vc_after_init', 'pistacia_vc_section_gmaps');