<?php
/**
 * ps_vc_section_footer_copyright.php
 *
 * Visual Composer Pistacia Footer
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_footer_copyright()
{
    vc_map(array(
        'name' => esc_html__('Pistacia Footer Copyright', 'pistacia'),
        'base' => 'ps_vc_section_footer_copyright',
        'category' => esc_html__('Pistacia elements', 'pistacia'),
        'description' => esc_html__('You can make custom copyright footer', 'pistacia'),
        'show_settings_on_create' => true,
        'weight' => -5,
        'html_template' => get_template_directory() . '/visual_composer/templates/ps_vc_section_footer_copyright_template.php',
        'admin_enqueue_js' => '',
        'admin_enqueue_css' => '',
        'front_enqueue_js' => '',
        'front_enqueue_css' => '',
        'js_view' => '',
        'icon' => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Bottom menu','pistacia'),
                'param_name' => 'bottom_menu',
                'value' => array_merge( array(esc_html__('default','pistacia') => 'default') , pistacia_get_all_navmenus_array() ),
                'description' => esc_html__( 'Choose one menu from all your nav menus', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'heading' =>  esc_html__('Copyright','pistacia'),
                'param_name' => 'copyright',
                'value' => ''
            ),
        )
    ));

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Footer_Copyright extends WPBakeryShortCode {
        }
    }

}

add_action('vc_after_init', 'pistacia_vc_section_footer_copyright');