<?php
/**
 * ps_vc_section_counter.php
 *
 * Visual Composer Pistacia Counter
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_section_counter() {

    vc_map( array(
            'name'                       => esc_html__( 'Pistacia Counter Section', 'pistacia' ),
            'base'                       => 'ps_vc_section_counter',
            'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
            'description'                => esc_html__( 'You can make counter section', 'pistacia' ),
            'show_settings_on_create'    => true,
            'weight'                     => - 5,
            'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_section_counter_template.php',
            'admin_enqueue_js'           => '',
            'admin_enqueue_css'          => '',
            'front_enqueue_js'           => '',
            'front_enqueue_css'          => '',
            'js_view'                    => 'VcColumnView',
            'as_parent'                  => array('only'=>'ps_vc_section_counter_item'),
            'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
            'content_element'            => true,
            'is_container'               => true,
            'params'                     => array(
                array(
                    'type' => 'attach_image',
                    'heading' => esc_html__( 'Background image', 'pistacia' ),
                    'param_name' => 'bg_img',
                    'value' => '',
                    'description' => ''
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Section title light', 'pistacia' ),
                    'param_name' => 'counter_section_title_light',
                    'value' => '',
                    'description' => ''
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Section title bold', 'pistacia' ),
                    'param_name' => 'counter_section_title_bold',
                    'value' => '',
                    'description' => ''
                )
            )
        )
    );

    vc_map( array(
            'name'                       => esc_html__('Pistacia Counter Item', 'pistacia'),
            'base'                       => 'ps_vc_section_counter_item',
            'html_template'              => '',
            'as_child'                   => array('only' => 'ps_vc_section_counter'),
            'show_settings_on_create'    => true,
            'js_view'                    => '',
            'is_container'               => false,
            'content_element'            => true,
            'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
            'params'                     => array(
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Counter number', 'pistacia' ),
                    'param_name' => 'counter_number',
                    'value' => '',
                    'description' => ''
                ),
                array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Item title', 'pistacia' ),
                    'param_name' => 'counter_title',
                    'value' => '',
                    'description' => ''
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Item direction', 'pistacia' ),
                    'param_name' => 'counter_direction',
                    'value' => array(
                        esc_html__('left to right','pistacia') => 'Left',
                        esc_html__('right to left','pistacia') => 'Right',
                    ),
                    'description' => esc_html__('animation direction left or right','pistacia')
                )
            )
        )
    );


    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Counter extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Section_Counter_Item extends  WPBakeryShortCode {
        }
    }

}

add_action('vc_after_init', 'pistacia_vc_section_counter');
