<?php
/**
 * ps_vc_recent_images_box.php
 *
 * Visual Composer Pistacia Recent Images Box
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

function pistacia_vc_recent_images_box() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Aside Recent Images Box', 'pistacia' ),
        'base'                    => 'ps_vc_recent_images_box',
        'category'                => esc_html__( 'Pistacia aside', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia recent images box', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_recent_images_box_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Box title', 'pistacia' ),
                'param_name' => 'title',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Box style', 'pistacia' ),
                'param_name' => 'box_style',
                'value' => array(
                    esc_html__('light','pistacia') => 'light',
                    esc_html__('dark','pistacia') => 'dark'
                ),
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Count', 'pistacia' ),
                'param_name' => 'posts_per_page',
                'value' => 9,
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order by', 'pistacia' ),
                'param_name' => 'orderby',
                'value' => array(
                    esc_html__('date','pistacia') => 'post_date',
                    esc_html__('title','pistacia') => 'title',
                    esc_html__('comment count','pistacia') => 'comment_count'
                ),
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order', 'pistacia' ),
                'param_name' => 'order',
                'value' => array(
                    esc_html__('DESC','pistacia') => 'DESC',
                    esc_html__('ASC','pistacia') => 'ASC'
                ),
                'description' => ''
            ),
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Recent_Images_Box extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}
add_action('vc_after_init', 'pistacia_vc_recent_images_box');
