<?php
/**
 * ps_vc_element_servicecarousel.php
 *
 * Visual Composer Pistacia Service Carousel
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.5.2
 */

function pistacia_vc_element_servicecarousel() {

    vc_map( array(
        'name'                       => esc_html__( 'Pistacia Service Carousel', 'pistacia' ),
        'base'                       => 'ps_vc_element_servicecarousel',
        'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'                => esc_html__( 'You can make service carousels', 'pistacia' ),
        'show_settings_on_create'    => false,
        'weight'                     => - 5,
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_element_servicecarousel_template.php',
        'admin_enqueue_js'           => '',
        'admin_enqueue_css'          => '',
        'front_enqueue_js'           => '',
        'front_enqueue_css'          => '',
        'js_view'                    => 'VcColumnView',
        'as_parent'                  => array('only'=>'ps_vc_servicecarousel_item'),
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'content_element'            => true,
        'is_container'               => true,
        'params'                     => array()
    ) );

    vc_map( array(
        'name'                       => esc_html__('Pistacia Service Carousel Item', 'pistacia'),
        'base'                       => 'ps_vc_servicecarousel_item',
        'as_child'                   => array('only' => 'ps_vc_element_servicecarousel'),
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_element_servicecarousel_item_template.php',
        'show_settings_on_create'    => true,
        'js_view'                    => 'VcIconElementView_Backend',
        'is_container'               => false,
        'content_element'            => true,
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                     => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Icon library', 'pistacia' ),
                'value' => array(
                    esc_html__( 'Font Awesome', 'pistacia' ) => 'fontawesome',
                    esc_html__( 'Open Iconic', 'pistacia' ) => 'openiconic',
                    esc_html__( 'Typicons', 'pistacia' ) => 'typicons',
                    esc_html__( 'Entypo', 'pistacia' ) => 'entypo',
                    esc_html__( 'Linecons', 'pistacia' ) => 'linecons',
                    esc_html__( 'Mono Social', 'pistacia' ) => 'monosocial',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_fontawesome',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontawesome',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_openiconic',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'openiconic',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'openiconic',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_typicons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'typicons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'typicons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_entypo',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'entypo',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'entypo',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_linecons',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'linecons',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'linecons',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'pistacia' ),
                'param_name' => 'icon_monosocial',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'monosocial',
                    'iconsPerPage' => 4000,
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'monosocial',
                ),
                'description' => esc_html__( 'Select icon library.', 'pistacia' ),
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Custom icon', 'pistacia' ),
                'param_name' => 'custom_icon',
                'description' => esc_html__('Upload custom icon or photo. 400x400 pixel','pistacia'),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Icon background', 'pistacia' ),
                'param_name' => 'icon_background',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Icon color', 'pistacia' ),
                'param_name' => 'icon_color',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'pistacia' ),
                'param_name' => 'title',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Description', 'pistacia' ),
                'param_name' => 'excerpt',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'More button text', 'pistacia' ),
                'param_name' => 'more_button_text',
                'value' => esc_html__('More','pistacia'),
                'description' => ''
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'Link', 'pistacia' ),
                'param_name' => 'link',
                'value' => '',
                'description' => ''
            ),
        ),
    ) );


    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Element_Servicecarousel extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Servicecarousel_Item extends  WPBakeryShortCode {}
    }

}

add_action('vc_after_init', 'pistacia_vc_element_servicecarousel');
