<?php
/**
 * ps_vc_element_recipes.php
 *
 * Visual Composer Pistacia Recent recipes show
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */

function pistacia_vc_element_recipes() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Recipes', 'pistacia' ),
        'base'                    => 'ps_vc_element_recipes',
        'category'                => esc_html__( 'Pistacia recipe', 'pistacia' ),
        'description'             => esc_html__( 'Show recent recipes page with filters', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_element_recipes_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type' => 'textfield',
                'value' => '5',
                'heading' =>  esc_html__('Columns','pistacia'),
                'param_name' => 'columns',
                'description' => esc_html__( 'How many columns show', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'value' => '10',
                'heading' =>  esc_html__('Recipe per page','pistacia'),
                'param_name' => 'perpage',
                'description' => esc_html__( 'How many recipes show per page', 'pistacia' )
            )
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_element_recipes extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}

global $pistacia_recipe_manager;

if ( !empty($pistacia_recipe_manager) ) {
    add_action('vc_after_init', 'pistacia_vc_element_recipes');
}
