<?php
/**
 * ps_vc_element_portfolio.php
 *
 * Visual Composer Pistacia Portfolio
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_element_portfolio()
{
    vc_map(array(
        'name' => esc_html__('Pistacia Galleries', 'pistacia'),
        'base' => 'ps_vc_element_portfolio',
        'category' => esc_html__('Pistacia elements', 'pistacia'),
        'description' => esc_html__('You can display latest galleries', 'pistacia'),
        'show_settings_on_create' => true,
        'weight' => -5,
        'html_template' => get_template_directory() . '/visual_composer/templates/ps_vc_element_portfolio_template.php',
        'admin_enqueue_js' => '',
        'admin_enqueue_css' => '',
        'front_enqueue_js' => '',
        'front_enqueue_css' => '',
        'js_view' => '',
        'icon' => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Portfolio count','pistacia'),
                'param_name' => 'portfolio_count',
                'value' => array(
                    esc_html__('all','pistacia') => -1,
                    '4' => 4,
                    '8' => 8,
                    '12' => 12,
                ),
                'description' => esc_html__( 'How many galleries display', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' =>  esc_html__('Photo size','pistacia'),
                'param_name' => 'img_size',
                'value' => array(
                    esc_html__('medium','pistacia') => 'medium',
                    esc_html__('large','pistacia') => 'large',
                    esc_html__('thumbnail','pistacia') => 'thumbnail',
                ),
                'description' => esc_html__( 'Thumbnail, Medium or Large', 'pistacia' )
            ),
        )
    ));

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Element_Portfolio extends WPBakeryShortCode {
        }
    }

}

global $pistacia_gallery_manager;

if ( !empty($pistacia_gallery_manager) ) {
    add_action('vc_after_init', 'pistacia_vc_element_portfolio');
}
