<?php
/**
 * ps_vc_element_menus.php
 *
 * Visual Composer Pistacia Menus
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.4.0
 */

function pistacia_vc_element_menus() {

    global $pistacia_menu_manager;

    vc_map( array(
        'name'                       => esc_html__( 'Pistacia Food Menus', 'pistacia' ),
        'base'                       => 'ps_vc_food_menus',
        'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'                => esc_html__( 'You can make food menus', 'pistacia' ),
        'show_settings_on_create'    => true,
        'weight'                     => - 5,
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_element_menus_template.php',
        'admin_enqueue_js'           => '',
        'admin_enqueue_css'          => '',
        'front_enqueue_js'           => '',
        'front_enqueue_css'          => '',
        'js_view'                    => '',
        'as_parent'                  => '',
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'content_element'            => true,
        'is_container'               => true,
        'params'                     => array(

            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Text color', 'pistacia' ),
                'param_name' => 'text_color',
                'value' => '',
                'description' => esc_html__( 'Overwrite text colors if you need' ,'pistacia')
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Categories', 'pistacia' ),
                'param_name' => 'menu_category',
                'value' => (!empty($pistacia_menu_manager)) ? $pistacia_menu_manager->get_menus_categories_select() : array(),
                'description' => esc_html__( 'Menu categories' ,'pistacia')
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order by', 'pistacia' ),
                'param_name' => 'order_by',
                'value' => array(
                    esc_html__('title','pistacia') => 'title',
                    esc_html__('date','pistacia') => 'date',
                    esc_html__('id','pistacia') => 'ID',
                ),
                'description' => esc_html__( 'Order by' ,'pistacia')
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Order', 'pistacia' ),
                'param_name' => 'order',
                'value' => array(
                    esc_html__('Ascendent','pistacia') => 'ASC',
                    esc_html__('Descendant','pistacia') => 'DESC',
                )
            ),

            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Box title', 'pistacia' ),
                'param_name' => 'title',
                'value' => '',
                'description' => esc_html__( 'Box title' ,'pistacia')
            ),

            array(
                'type' => 'checkbox',
                'heading' => esc_html__( 'Show photo', 'pistacia' ),
                'param_name' => 'show_photo',
                'value' => false,
                'description' => esc_html__( 'Show or hide photo' , 'pistacia' )
            ),

            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Photo style', 'pistacia' ),
                'param_name' => 'photo_style',
                'value' => array(
                    esc_html__('circle','pistacia') => 'img-circle',
                    esc_html__('rounded','pistacia') => 'img-rounded',
                    esc_html__('thumbnail','pistacia') => 'img-thumbnail'
                ),
                'description' => esc_html__( 'Style menus photo' ,'pistacia')
            ),

        )
    ) );


    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Food_Menus extends  WPBakeryShortCode {
        }
    }

}

global $pistacia_menu_manager;

if( !empty( $pistacia_menu_manager ) ) {
    add_action('vc_after_init', 'pistacia_vc_element_menus');
}
