<?php
/**
 * ps_vc_element_menu_cards.php
 *
 * Visual Composer Pistacia Menu Cards
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_element_menu_cards() {

    vc_map( array(
        'name'                       => esc_html__( 'Pistacia Menu Cards', 'pistacia' ),
        'base'                       => 'ps_vc_element_menu_cards',
        'category'                   => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'                => esc_html__( 'You can make menu cards section', 'pistacia' ),
        'show_settings_on_create'    => false,
        'weight'                     => - 5,
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_element_menu_cards_template.php',
        'admin_enqueue_js'           => '',
        'admin_enqueue_css'          => '',
        'front_enqueue_js'           => '',
        'front_enqueue_css'          => '',
        'js_view'                    => 'VcColumnView',
        'as_parent'                  => array('only'=>'ps_vc_element_menu_cards_item'),
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'content_element'            => true,
        'is_container'               => true,
        'params'                     => array(

        )
    ) );

    vc_map( array(
        'name'                       => esc_html__('Pistacia Menu Cards Item', 'pistacia'),
        'base'                       => 'ps_vc_element_menu_cards_item',
        'html_template'              => '',
        'as_child'                   => array('only' => 'ps_vc_element_menu_cards'),
        'show_settings_on_create'    => true,
        'js_view'                    => '',
        'is_container'               => false,
        'content_element'            => true,
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                     => array(
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Menu photo', 'pistacia' ),
                'param_name' => 'image',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'pistacia' ),
                'param_name' => 'title',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'textarea',
                'heading' => esc_html__( 'Excerpt', 'pistacia' ),
                'param_name' => 'excerpt',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Menu ratings', 'pistacia' ),
                'param_name' => 'ratings',
                'value' => array(
                    esc_html__('1 star','pistacia') => 1,
                    esc_html__('2 stars','pistacia') => 2,
                    esc_html__('3 stars','pistacia') => 3,
                    esc_html__('4 stars','pistacia') => 4,
                    esc_html__('5 stars','pistacia') => 5,
                ),
                'description' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Price', 'pistacia' ),
                'param_name' => 'price',
                'value' => '',
                'description' => ''
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'Link', 'pistacia' ),
                'param_name' => 'card_link',
                'value' => '',
                'description' => ''
            ),


        ),
    ) );


    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Element_Menu_Cards extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Element_Menu_Cards_Item extends  WPBakeryShortCode {
        }
    }

}

add_action('vc_after_init', 'pistacia_vc_element_menu_cards');