<?php
/**
 * ps_vc_element_footer_testimony.php
 *
 * Visual Composer Pistacia Footer Testimany Slider
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.3.2
 */

function pistacia_vc_element_footer_testimony() {

    vc_map( array(
        'name'                    => esc_html__( 'Pistacia Footer Testimony Slider', 'pistacia' ),
        'base'                    => 'ps_vc_element_footer_testimony',
        'category'                => esc_html__( 'Pistacia footer', 'pistacia' ),
        'description'             => esc_html__( 'You can make testimony slider', 'pistacia' ),
        'show_settings_on_create' => false,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_footer_testimony_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => 'VcColumnView',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'content_element'         => true,
        'is_container'            => false,
        'as_parent'               => array('only'=>'ps_vc_footer_testimony_item'),
        'params'                  => array()
    ) );

    vc_map( array(
        'name'                       => esc_html__('Pistacia Testimony Item', 'pistacia'),
        'base'                       => 'ps_vc_footer_testimony_item',
        'html_template'              => get_template_directory() . '/visual_composer/templates/ps_vc_footer_testimony_item_template.php',
        'content_element'            => true,
        'as_child'                   => array('only' => 'ps_vc_element_footer_testimony'),
        'show_settings_on_create'    => true,
        'icon'                       => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params' => array(
            array(
                'type' => 'attach_image',
                'heading' =>  esc_html__('Photo','pistacia'),
                'param_name' => 'photo',
                'description' => esc_html__( 'Upload photo. Use 300x300 pixel', 'pistacia' )
            ),
            array(
                'type' => 'textfield',
                'heading' =>  esc_html__('Testimony','pistacia'),
                'param_name' => 'testimony',
                'value' => ''
            ),
            array(
                'type' => 'textfield',
                'heading' =>  esc_html__('Name','pistacia'),
                'param_name' => 'name',
                'value' => ''
            ),
            array(
                'type' => 'colorpicker',
                'heading' =>  esc_html__('Text color','pistacia'),
                'param_name' => 'text_color',
                'description' => ''
            ),
        ),
    ) );

    if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
        class WPBakeryShortCode_Ps_Vc_Element_Footer_Testimony extends WPBakeryShortCodesContainer {
        }
    }

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Footer_Testimony_Item extends WPBakeryShortCode {
        }
    }

}


add_action('vc_after_init', 'pistacia_vc_element_footer_testimony');
