<?php
/**
 * ps_vc_comments.php
 *
 * Visual Composer Pistacia Comments
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

function pistacia_vc_comments_box() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Comments', 'pistacia' ),
        'base'                    => 'ps_vc_comments',
        'category'                => esc_html__( 'Pistacia elements', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia comments', 'pistacia' ),
        'show_settings_on_create' => false,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_comments_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'js_view'                 => '',
        'params'                  => array(
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Comments extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}
add_action('vc_after_init', 'pistacia_vc_comments_box');
