<?php
/**
 * ps_vc_categories_box.php
 *
 * Visual Composer Pistacia Categories Box
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

function pistacia_vc_categories_box() {
    $settings = array(
        'name'                    => esc_html__( 'Pistacia Aside Categories Box', 'pistacia' ),
        'base'                    => 'ps_vc_categories_box',
        'category'                => esc_html__( 'Pistacia aside', 'pistacia' ),
        'description'             => esc_html__( 'Pistacia categories box', 'pistacia' ),
        'show_settings_on_create' => true,
        'weight'                  => - 5,
        'html_template'           => get_template_directory() . '/visual_composer/templates/ps_vc_categories_box_template.php',
        'admin_enqueue_js'        => '',
        'admin_enqueue_css'       => '',
        'front_enqueue_js'        => '',
        'front_enqueue_css'       => '',
        'js_view'                 => '',
        'icon'                    => get_template_directory_uri() . '/visual_composer/img/ps-icon.png',
        'params'                  => array(
            array(
                'type'        => 'textfield',
                'heading'     => esc_html__( 'Box title', 'pistacia' ),
                'param_name'  => 'title',
                'description' => esc_html__( 'Type box title', 'pistacia' )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Box style', 'pistacia' ),
                'param_name' => 'box_style',
                'value' => array(
                    esc_html__('light','pistacia') => 'light',
                    esc_html__('dark','pistacia') => 'dark'
                ),
                'description' => ''
            ),
        )
    );
    vc_map( $settings );

    if ( class_exists( 'WPBakeryShortCode' ) ) {
        class WPBakeryShortCode_Ps_Vc_Categories_Box extends WPBakeryShortCode {
            public function __construct( $settings ) {
                parent::__construct( $settings );
            }
        }
    }
}
add_action('vc_after_init', 'pistacia_vc_categories_box');
