<?php
/**
 * single.php
 *
 * This file contains single
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */?>
<?php get_header();?>

<?php if ( function_exists('get_field') ) : ?>

    <?php if ( get_post_format() != 'video' ): ?>

        <?php if ( get_field( 'ps_header_img' ) ) : ?>
            <header class="header">
                <div class="header-img" style="background-image:url('<?php echo esc_url( get_field( 'ps_header_img' ) );?>')">
                    <div class="overlay overlay-black-70"></div>
                </div>
            </header>
        <?php endif; ?>

    <?php endif; ?>

<?php endif; ?>

<?php $aside = ( is_active_sidebar( 'pistacia_single_sb' ) ) ? true : false; ?>
<?php $aside_alignment = ( function_exists('get_field') && get_field('pistacia_o_blogs_aside','option') ) ? get_field('pistacia_o_blogs_aside','option') : 'left'  ?>

<?php if ( have_posts() ): ?>

    <section class="single-post">

        <div class="container">

            <div class="col-md-<?php echo $aside ? '8' : '12'; ?><?php echo ( $aside_alignment == 'left' ) ? ' col-md-push-4' : ''; ?>">

                <?php while ( have_posts() ): the_post(); ?>

                    <?php if (function_exists('get_field')) : ?>
                        <?php $featured_video = get_field('pistacia_featured_video'); ?>
                    <?php endif; ?>

                    <?php if( !empty( $featured_video ) ): ?>
                        <div class="embed-responsive post-video embed-responsive-16by9">
                            <?php the_field('pistacia_featured_video'); ?>
                        </div>
                    <?php endif; ?>

                    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                        <?php if ( ( has_post_thumbnail()) && ( empty( $featured_video ) ) ) : ?>

                            <?php $image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' ); ?>

                            <div class="post-photo">
                                <img src="<?php echo esc_url($image_src[0]);?>" class="img-responsive img-thumbnail" alt="">
                            </div>

                        <?php endif; ?>

                        <div class="row">

                            <div class="col-md-12">

                                <div class="post-date">
                                    <span class="day"><?php echo esc_html(get_the_date('d',get_the_ID())); ?></span>
                                    <span class="month"><?php pistacia_the_month_name( get_the_date('m', get_the_ID()) ); ?></span>
                                </div>

                                <div class="post-like">
                                    <p><i class="fa fa-comments"></i></p>
                                    <span><?php $count = wp_count_comments( get_the_ID() ); echo esc_html($count->total_comments);?></span>
                                </div>

                                <div class="post-title">
                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                    <span><?php esc_html_e('Posted by','pistacia');?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author();?></a></span>
                                </div>

                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="tagsandcategories">
                                    <?php esc_html_e('Categories','pistacia');?>: <?php the_category(', ');?>
                                    <?php esc_html_e('Tags','pistacia');?>: <?php the_tags(', ');?>
                                </div>
                                <div class="post-lead">
                                    <?php the_excerpt(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="post-text">
                                    <?php the_content(); ?>
                                </div>
                            </div>
                        </div>

                        <?php if ( pistacia_has_share_buttons() ) : ?>
                            <h4 class="text-center"><?php esc_html_e('Share this page','pistacia');?>:</h4>
                            <?php pistacia_the_share_buttons( get_permalink() );?>
                        <?php endif; ?>

                        <hr class="zigzag">

                        <?php if ( comments_open() ){
                            comments_template();
                        } ?>

                    </div>

                <?php endwhile; ?>

            </div>

            <?php if ( $aside ) : ?>
                    <div class="col-md-4 pistacia-aside<?php echo ( $aside_alignment == 'left' ) ? ' col-md-pull-8' : ''; ?>">
                        <?php dynamic_sidebar( 'pistacia_single_sb' ); ?>
                    </div>
            <?php endif; ?>

        </div>

    </section>

<?php endif; ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer();?>
