<?php
/**
 * single-pistacia_recipes.php
 *
 * This file contains single recipes
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.1.0
 */

get_header(); ?>

<?php $pistacia_recipe = new Pistacia_Recipe(); ?>
<?php $pistacia_recipe->set_recipe( get_the_ID() ); ?>

    <section id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <div class="recipe-section-inner">

            <div class="recipe-info-wrapper" style="background-image:url('<?php echo esc_url( $pistacia_recipe->get_head_src() );?>');">

                <div class="recipe-info-inner">

                    <div class="container">

                        <?php $src = $pistacia_recipe->get_attachment_scr('large'); ?>
                        <?php if (!empty( $src )) : ?>
                            <div class="col-md-7">
                                <div class="photo">
                                    <img class="img-responsive" src="<?php echo esc_url( $pistacia_recipe->get_attachment_scr('large') );?>" alt="">
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-md-<?php echo ( empty($src) ) ? '12' : '5'; ?> recipe-info-box">

                            <div class="recipe-infos">

                                <div class="recipe-infos-inner">

                                    <?php $pistacia_recipe->the_recipe_author(); ?>
                                    <?php $pistacia_recipe->the_title(); ?>
                                    <?php $pistacia_recipe->the_excerpt(); ?>
                                    <?php $pistacia_recipe->the_recipe_difficulty(); ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>


            <div class="recipe-info-line">

                <div class="recipe-properties-box">

                    <div class="container">

                        <div class="col-md-12">
                            <?php $pistacia_recipe->the_recipe_props(); ?>
                        </div>

                    </div>

                </div>

            </div>


            <div class="recipe-wrapper">

                <div class="container">

                    <div class="col-md-4">
                        <?php $pistacia_recipe->the_ingredients_box(); ?>
                        <?php $pistacia_recipe->the_recipe_gallery_box(); ?>
                        <?php $pistacia_recipe->the_recipe_tags_box(); ?>
                    </div>

                    <div class="col-md-8">

                        <?php $pistacia_recipe->the_recipe_categories_box(); ?>
                        <?php $pistacia_recipe->the_methode_box(); ?>

                        <div class="hidden-print">
                            <?php if ( comments_open() ){
                                comments_template();
                            } ?>
                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>


<?php
// TODO Recipes submit form
//get_template_part( 'partials/section', 'recipe-submit' );
?>

<?php get_template_part( 'partials/section', 'recipes-tops' ); ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer(); ?>