<?php
/**
 * single-gallery.php
 *
 * This file contains single gallery
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

get_header(); ?>

<?php if( function_exists('get_field')): ?>

    <?php if ( get_field( 'ps_header_img' ) ) : ?>
        <header class="header">
            <div class="header-img" style="background-image:url('<?php echo esc_url( get_field( 'ps_header_img' ) );?>')">
                <div class="overlay overlay-black-70"></div>
            </div>
        </header>
    <?php endif; ?>

    <?php if ( have_posts()) : ?>

        <?php while ( have_posts()): the_post();?>

            <section class="portfolio" id="portfolio">

                <div class="container">

                    <h1 class="text-center"><span class="light"><?php the_title();?></span></h1>

                    <div class="zigzag"><i class="fa fa-image"></i></div>

                    <div class="row">
                        <div class="col-md-offset-3 col-md-6">
                            <p class="text-center lead"><?php echo get_the_excerpt(); ?></p>
                        </div>
                    </div>

                    <ul class="gallery-items">

                        <?php $images = get_field( 'ps_gallery_items' ); ?>

                        <?php if ( !empty( $images ) ) : ?>

                            <?php foreach( $images as $img ) : ?>

                                <li class="item">

                                    <div class="item-container">

                                        <figure class="figure-hubba">
                                            <img src="<?php echo esc_url( $img['sizes']['thumbnail'] );?>" class="img-responsive wait-for-load" alt="<?php echo esc_attr($img['alt']);?>">
                                            <figcaption class="figcaption">
                                                <a href="<?php echo esc_url( $img['url'] );?>" class="icon swipebox"><i class="fa fa-search"></i></a>
                                            </figcaption>
                                        </figure>

                                    </div>

                                </li>

                            <?php endforeach; ?>

                        <?php endif; ?>

                    </ul>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="gallery-content">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>

                </div>

            </section>

        <?php endwhile; ?>

    <?php endif; ?>

<?php endif; ?>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer(); ?>