<?php
/**
 * searchpage.php
 *
 * This file contains search
 *
 * @themename      Pistacia - Recipe & Food & Restaurant Responsive WordPress Theme
 * @author         Pistaciatheme
 * @authoruri      http://themeforest.net/user/pistaciatheme
 * @themeuri       http://wp.pistaciatheme.com/pistacia
 * @description    Food and Restaurant WordPress Responsive Theme
 * @version        1.6.7
 * @license        GPL-3.0
 * @licenseuri     http://www.gnu.org/licenses/gpl-3.0.html
 * @package        WordPress
 * @subpackage     pistacia
 * @since          pistacia 1.0.0
 */

get_header(); ?>

    <header class="header">
        <div class="header-img" style="background-image:url('<?php header_image(); ?>');">
            <div class="overlay overlay-black-70"></div>
        </div>
    </header>

    <section class="search-section">

        <div class="container">
            <?php if( have_posts() ) : ?>

                <h3><?php esc_html_e('Search results','pistacia');?></h3>

                <ul class="clearfix">
                    <?php while( have_posts() ) : the_post(); ?>
                        <li>
                            <a href="<?php the_permalink();?>"><?php esc_html( the_title() ); ?></a>
                        </li>
                    <?php endwhile; ?>
                </ul>

                <div class="text-center paginator-wrapper">

                    <?php the_posts_pagination( array(
                        'mid_size'  => 2,
                        'prev_text' => esc_html__( 'Previous', 'pistacia' ),
                        'next_text' => esc_html__( 'Forward', 'pistacia' ) ));?>

                </div>

            <?php else: ?>

                <?php esc_html_e('No search results','pistacia');?>

            <?php endif; ?>

        </div>

    </section>

<?php get_template_part( 'partials/section', 'footer' ); ?>
<?php get_template_part( 'partials/section', 'bottom-bar' ); ?>

<?php get_footer(); ?>